/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSBLOBIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSBLOBReader;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.utils.ResultSetDataElement;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSBlobDataSource
implements DataSource,
ContentTypeDataSource {
    private static Logger log = LoggerFactory.getLogger(RSBlobDataSource.class);
    private RSBLOBIterator rsiterator = null;
    private RSBLOBReader rsreader = null;
    private boolean isClosed = false;

    public RSBlobDataSource(String input, Parameter[] inputParameters) {
        try {
            RSBLOBIterator iterator;
            this.rsreader = RSBLOBReader.getRSBLOBReader((RSLocator)new RSLocator(input)).makeLocal((RSResourceType)new RSResourceLocalType());
            this.rsiterator = iterator = this.rsreader.getRSIterator();
        }
        catch (Exception e) {
            log.error("Could not create blob iterator", (Throwable)e);
        }
    }

    public boolean hasNext() {
        if (this.rsiterator == null) {
            return false;
        }
        return this.rsiterator.hasNext();
    }

    public DataElement next() {
        if (this.rsiterator == null) {
            return null;
        }
        ResultSetDataElement rsElement = (ResultSetDataElement)this.rsiterator.next(ResultSetDataElement.class);
        if (rsElement == null) {
            log.warn("Got null object...");
            return null;
        }
        log.debug("Got object with id " + rsElement.getOID());
        return rsElement.getDataElement();
    }

    public void close() {
        try {
            if (!this.isClosed) {
                this.isClosed = true;
                this.rsreader.clear();
            }
        }
        catch (Exception e) {
            log.error("Did not manage to clear rs reader", (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public ContentType nextContentType() {
        DataElement de = this.next();
        return de == null ? null : de.getContentType();
    }
}

