/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.common.clients.queries.Query;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.streams.Stream;
import org.gcube.data.tml.proxies.TReader;
import org.gcube.data.tml.proxies.TServiceFactory;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.XMLBindings;
import org.gcube.data.trees.patterns.EdgePattern;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;
import org.gcube.datatransformation.datatransformationlibrary.DTSCore;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataBridge;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.PathDataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.utils.RSDataElementUtil;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.gcube.datatransformation.datatransformationlibrary.utils.queue.MemoryFileBackedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TMDataSource
implements DataSource,
ContentTypeDataSource {
    private String treeCollectionID;
    private DataBridge bridge = DTSCore.getDataBridge();
    private static Logger log = LoggerFactory.getLogger(TMDataSource.class);
    private Stream<Tree> treesReader;
    private volatile boolean finished = false;
    private Object sync = new Object();
    private static MemoryFileBackedQueue<String> queue;

    public TMDataSource(String input, Parameter[] inputParameters) {
        this.treeCollectionID = input;
        log.debug("Going to fetch objects from tree manager with id: " + this.treeCollectionID);
        if (GCUBEScopeManager.DEFAULT.getScope() == null) {
            GCUBEScopeManager.DEFAULT.setScope(DTSSManager.getScope());
        }
        StatefulQuery query = TServiceFactory.readSource().withId(this.treeCollectionID).build();
        TReader treader = (TReader)TServiceFactory.reader().matching((Query)query).build();
        this.treesReader = treader.get((Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block11: {
                    this.setName("TMDataSourceRetriever");
                    try {
                        queue = new MemoryFileBackedQueue(100);
                        final String seperator = UUID.randomUUID().toString();
                        new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                log.info("File backed queue created for storing trees");
                                int i = 0;
                                while (TMDataSource.this.treesReader.hasNext()) {
                                    log.trace("goidg to fetch tree #" + (i + 1));
                                    Tree t = (Tree)TMDataSource.this.treesReader.next();
                                    if (++i % 100 == 0) {
                                        log.debug("fetched " + i + " trees.");
                                    }
                                    log.trace("tree #" + i + " retrived");
                                    String strRepr = t.uri().toASCIIString();
                                    strRepr = strRepr + seperator;
                                    strRepr = strRepr + XMLBindings.toString((Tree)t);
                                    queue.offer(strRepr);
                                    log.trace("hasNext?");
                                    Object object = TMDataSource.this.sync;
                                    synchronized (object) {
                                        TMDataSource.this.sync.notify();
                                    }
                                }
                                Object object = TMDataSource.this.sync;
                                synchronized (object) {
                                    TMDataSource.this.finished = true;
                                    TMDataSource.this.sync.notify();
                                }
                            }
                        }.start();
                        String payload = "";
                        while (!(TMDataSource.this.finished && queue.size() <= 0 || TMDataSource.this.bridge.isClosed())) {
                            Object object = TMDataSource.this.sync;
                            synchronized (object) {
                                while (queue.size() == 0) {
                                    TMDataSource.this.sync.wait();
                                    if (!TMDataSource.this.finished) continue;
                                    break block11;
                                }
                            }
                            String str = (String)queue.poll();
                            if (str == null) {
                                log.warn("Queue returned null");
                                continue;
                            }
                            String id = str.substring(0, str.indexOf(seperator));
                            payload = str.substring(str.indexOf(seperator) + seperator.length());
                            TMDataSource.this.manageObject(id, payload);
                        }
                    }
                    catch (Exception e) {
                        log.error("Did not manage to fetch content from cms", (Throwable)e);
                    }
                    finally {
                        log.info("Removing queue.");
                        queue.destroy();
                        TMDataSource.this.bridge.close();
                    }
                }
            }
        }.start();
    }

    public void close() {
        this.bridge.close();
    }

    public boolean isClosed() {
        return this.bridge.isClosed();
    }

    public ContentType nextContentType() {
        DataElement de = this.bridge.next();
        return de == null ? null : de.getContentType();
    }

    public boolean hasNext() {
        return this.bridge.hasNext();
    }

    public DataElement next() {
        return this.bridge.next();
    }

    private void manageObject(String id, String payload) {
        try {
            StrDataElement object = StrDataElement.getSourceDataElement();
            object.setId(id);
            object.setContent(payload);
            object.setAttribute("CollectionID", this.treeCollectionID);
            object.setAttribute("ContentOID", id);
            object.setContentType(new ContentType("application/xml", new ArrayList()));
            this.bridge.append((DataElement)object);
            log.trace("Object with id " + id + " was added for processing by TM");
            ReportManager.manageRecord((String)id, (String)("Object with id " + id + " was added for processing by TM"), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.SOURCE);
        }
        catch (Exception e) {
            log.error("Could not manage to fetch the object " + id, (Throwable)e);
            ReportManager.manageRecord((String)id, (String)("Object with id " + id + " could not be fetched TM"), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SOURCE);
        }
    }

    public static void main(String[] args) throws Exception {
        String scope = "/gcube/devNext";
        ScopeProvider.instance.set(scope);
        DTSSManager.setScope((String)scope);
        String input = "553e9014-fd4f-45fd-868e-07834c55b83b";
        input = "7374617475733D756E707562";
        input = "FIGIS";
        TMDataSource ds = new TMDataSource(input, null);
        boolean i = false;
        while (ds.hasNext()) {
            StringWriter writer = new StringWriter();
            DataElement de = ds.next();
            IOUtils.copy((InputStream)de.getContent(), (Writer)writer, (String)"UTF-8");
            String theString = writer.toString();
            System.out.println(de.getId());
            System.out.println(theString);
        }
        ArrayList<TMDataSource> sources = new ArrayList<TMDataSource>();
        sources.add(ds);
        while (ds.hasNext()) {
            System.out.println(RSDataElementUtil.stringFromInputStream(ds.next().getContent()));
        }
        Thread.sleep(3600000L);
        ArrayList<Parameter> programParameters = new ArrayList<Parameter>();
        programParameters.add(new Parameter("xslt:1", "$BrokerXSLT_DwC-A_anylanguage_to_ftRowset_anylanguage"));
        programParameters.add(new Parameter("xslt:2", "$BrokerXSLT_TAXONOMY_anylanguage_to_ftRowset_anylanguage"));
        programParameters.add(new Parameter("xslt:3", "$BrokerXSLT_PROVENANCE_anylanguage_to_ftRowset_anylanguage"));
        programParameters.add(new Parameter("finalftsxslt", "$BrokerXSLT_wrapperFT"));
        programParameters.add(new Parameter("indexType", "haha_2.0"));
        ContentType targetContentType = new ContentType();
        targetContentType.setMimeType("text/xml");
        targetContentType.setContentTypeParameters(Arrays.asList(new Parameter("schemaURI", "http://ftrowset.xsd")));
        PathDataSink sink = new PathDataSink("/home/jgerbe/testArea/sink", null);
        sink.getOutput();
        Thread.sleep(3600000L);
    }
}

