/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.common.clients.queries.Query;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.streams.Stream;
import org.gcube.data.tml.proxies.TReader;
import org.gcube.data.tml.proxies.TServiceFactory;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.XMLBindings;
import org.gcube.data.trees.patterns.EdgePattern;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;
import org.gcube.datatransformation.datatransformationlibrary.DTSCore;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataBridge;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.PathDataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.utils.RSDataElementUtil;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TMDataSource
implements DataSource,
ContentTypeDataSource {
    private String treeCollectionID;
    private DataBridge bridge = DTSCore.getDataBridge();
    private static Logger log = LoggerFactory.getLogger(TMDataSource.class);
    private Stream<Tree> treesReader;

    public TMDataSource(String input, Parameter[] inputParameters) {
        this.treeCollectionID = input;
        log.debug("Going to fetch objects from tree manager with id: " + this.treeCollectionID);
        if (GCUBEScopeManager.DEFAULT.getScope() == null) {
            GCUBEScopeManager.DEFAULT.setScope(DTSSManager.getScope());
        }
        StatefulQuery query = TServiceFactory.readSource().withId(this.treeCollectionID).build();
        TReader treader = (TReader)TServiceFactory.reader().matching((Query)query).build();
        this.treesReader = treader.get((Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.setName("TMDataSourceRetriever");
                File tempIDsStorage = null;
                try {
                    String id;
                    String seperator = UUID.randomUUID().toString();
                    tempIDsStorage = File.createTempFile("DTS", ".tmp");
                    log.info("File storing Trees: " + tempIDsStorage.getName());
                    BufferedWriter out = new BufferedWriter(new FileWriter(tempIDsStorage));
                    int i = 0;
                    while (TMDataSource.this.treesReader.hasNext()) {
                        Tree t = (Tree)TMDataSource.this.treesReader.next();
                        if (++i % 100 == 0) {
                            log.debug("Pre-fetched " + i + " trees.");
                        }
                        out.write(t.uri() + "\n");
                        out.write(XMLBindings.toString((Tree)t) + "\n");
                        out.write(seperator + "\n");
                    }
                    out.close();
                    log.info("Done prefetching trees...");
                    String payload = "";
                    BufferedReader in = new BufferedReader(new FileReader(tempIDsStorage));
                    while ((id = in.readLine()) != null && !id.isEmpty()) {
                        String str = in.readLine();
                        while (!str.equals(seperator)) {
                            payload = payload + str;
                            str = in.readLine();
                        }
                        TMDataSource.this.manageObject(id, payload);
                        payload = "";
                    }
                    in.close();
                    log.info("Removing temp file.");
                    tempIDsStorage.delete();
                }
                catch (Exception e) {
                    log.error("Did not manage to fetch content from cms", (Throwable)e);
                }
                finally {
                    TMDataSource.this.bridge.close();
                }
            }
        }.start();
    }

    public void close() {
        this.bridge.close();
    }

    public boolean isClosed() {
        return this.bridge.isClosed();
    }

    public ContentType nextContentType() {
        DataElement de = this.bridge.next();
        return de == null ? null : de.getContentType();
    }

    public boolean hasNext() {
        return this.bridge.hasNext();
    }

    public DataElement next() {
        return this.bridge.next();
    }

    private void manageObject(String id, String payload) {
        try {
            StrDataElement object = StrDataElement.getSourceDataElement();
            object.setId(id);
            object.setContent(payload);
            object.setAttribute("CollectionID", this.treeCollectionID);
            object.setAttribute("ContentOID", id);
            object.setContentType(new ContentType("application/xml", new ArrayList()));
            this.bridge.append((DataElement)object);
            log.trace("Object with id " + id + " was added for processing by TM");
            ReportManager.manageRecord((String)id, (String)("Object with id " + id + " was added for processing by TM"), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.SOURCE);
        }
        catch (Exception e) {
            log.error("Could not manage to fetch the object " + id, (Throwable)e);
            ReportManager.manageRecord((String)id, (String)("Object with id " + id + " could not be fetched TM"), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SOURCE);
        }
    }

    public static void main(String[] args) throws Exception {
        ScopeProvider.instance.set("/gcube/devNext");
        DTSSManager.setScope((String)"/gcube/devNext");
        String input = "ijoat:OTHR";
        TMDataSource ds = new TMDataSource(input, null);
        while (ds.hasNext()) {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)ds.next().getContent(), (Writer)writer, (String)"UTF-8");
            String theString = writer.toString();
            System.out.println(theString);
        }
        ArrayList<TMDataSource> sources = new ArrayList<TMDataSource>();
        sources.add(ds);
        Thread.sleep(3600000L);
        while (ds.hasNext()) {
            System.out.println(RSDataElementUtil.stringFromInputStream(ds.next().getContent()));
        }
        Thread.sleep(3600000L);
        ArrayList<Parameter> programParameters = new ArrayList<Parameter>();
        programParameters.add(new Parameter("xslt:1", "$BrokerXSLT_DwC-A_anylanguage_to_ftRowset_anylanguage"));
        programParameters.add(new Parameter("xslt:2", "$BrokerXSLT_TAXONOMY_anylanguage_to_ftRowset_anylanguage"));
        programParameters.add(new Parameter("xslt:3", "$BrokerXSLT_PROVENANCE_anylanguage_to_ftRowset_anylanguage"));
        programParameters.add(new Parameter("finalftsxslt", "$BrokerXSLT_wrapperFT"));
        programParameters.add(new Parameter("indexType", "haha_2.0"));
        ContentType targetContentType = new ContentType();
        targetContentType.setMimeType("text/xml");
        targetContentType.setContentTypeParameters(Arrays.asList(new Parameter("schemaURI", "http://ftrowset.xsd")));
        PathDataSink sink = new PathDataSink("/home/jgerbe/testArea/sink", null);
        sink.getOutput();
        Thread.sleep(3600000L);
    }
}

