/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.utils.Locators;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RS2DataSink
implements DataSink {
    private static Logger log = LoggerFactory.getLogger(RS2DataSink.class);
    private RecordDefinition[] defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{new StringFieldDefinition("Rowset")})};
    private Boolean flush = false;
    private int wroterecs = 0;
    private RecordWriter<GenericRecord> writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), this.defs, RecordWriter.DefaultBufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor, 1L, TimeUnit.DAYS);
    private boolean isClosed = false;

    public RS2DataSink(String output, Parameter[] outputParameters) throws Exception {
    }

    private static String stringFromInputStream(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    public void append(DataElement dataElement) {
        GenericRecord rec = new GenericRecord();
        try {
            String payload = dataElement instanceof StrDataElement ? ((StrDataElement)dataElement).getStringContent() : RS2DataSink.stringFromInputStream(dataElement.getContent());
            rec.setFields(new Field[]{new StringField(payload)});
            int hours = 1;
            while (!this.writer.put((Record)rec, 1L, TimeUnit.HOURS)) {
                IBuffer.Status s = this.writer.getStatus();
                log.debug("RS buffer full.... looping... " + dataElement.getId() + " status " + s.toString());
                if (++hours <= 25) continue;
                log.info("Transformation has remained idle for one day. Closing writer.");
                this.writer.close();
                this.writer = null;
                this.flush = true;
            }
            ++this.wroterecs;
            log.debug("Wrote record (" + this.wroterecs + ") #" + dataElement.getId());
        }
        catch (Exception e) {
            if (this.flush.booleanValue()) {
                log.info("Flushing output.");
            } else {
                log.error("Failed to create RS2 element", (Throwable)e);
            }
            return;
        }
    }

    public void close() {
        try {
            this.isClosed = true;
            log.debug("Total records added: " + this.writer.totalRecords());
            this.writer.close();
            ReportManager.closeReport();
        }
        catch (Exception e) {
            log.error("Could not close RSXMLWriter ", (Throwable)e);
        }
    }

    public String getOutput() {
        try {
            URI TCPLocator = Locators.localToTCP((URI)this.writer.getLocator());
            return TCPLocator.toString();
        }
        catch (Exception e) {
            log.error("Did not manage to create the RS Locator", (Throwable)e);
            return null;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

