/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.net.URI;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.datatransformation.datatransformationlibrary.DTSCore;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataBridge;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.handlers.CMSUtils;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlternativeRepresentationDataSink
extends Thread
implements DataSink {
    private static Logger log = LoggerFactory.getLogger(AlternativeRepresentationDataSink.class);
    protected static final String PARAMETER_RepresentationRole = "RepresentationRole";
    private String documentName = "dtsproducedaltrepr";
    private String representationRole;
    private DataBridge bridge = DTSCore.getHardDataBridge();

    public AlternativeRepresentationDataSink(String output, Parameter[] outputParameters) {
        if (outputParameters != null && outputParameters.length > 0) {
            for (Parameter param : outputParameters) {
                if (param == null || param.getName() == null || param.getValue() == null || !param.getName().equals(PARAMETER_RepresentationRole) || param.getValue() == null || param.getValue().trim().length() <= 0) continue;
                this.representationRole = param.getValue();
            }
        }
        this.start();
    }

    public void append(DataElement element) {
        if (element != null) {
            this.bridge.append(element);
        }
    }

    public void close() {
        this.bridge.close();
    }

    public String getOutput() {
        return "nothing";
    }

    @Override
    public void run() {
        block4: while (true) {
            try {
                while (this.bridge.hasNext()) {
                    DataElement dataElement = this.bridge.next();
                    if (dataElement == null) continue;
                    log.debug("Going to store alternative representation of the object with id " + dataElement.getId() + " and content type " + dataElement.getContentType().toString());
                    try {
                        String docURL = dataElement.getAttributeValue("ContentOID");
                        log.debug("Document has URL: " + docURL);
                        String collectionID = URIs.collectionID((URI)new URI(docURL));
                        String documentID = URIs.documentID((URI)new URI(docURL));
                        DocumentWriter cmWriter = new DocumentWriter(collectionID, DTSSManager.getScope(), DTSSManager.getSecurityManager());
                        GCubeDocument gdoc = new GCubeDocument(documentID);
                        if (dataElement.getAttributeValue("DocumentName") == null || dataElement.getAttributeValue("DocumentName").length() == 0) {
                            dataElement.setAttribute("DocumentName", this.documentName);
                        }
                        CMSUtils.storeDataElementToCMAsAlternativeRepresentation(cmWriter, gdoc, dataElement, this.representationRole);
                        ReportManager.manageRecord((String)dataElement.getId(), (String)("Alternative representation of object with id " + dataElement.getId() + " and content type " + dataElement.getContentType().toString() + " was stored successfully"), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.SINK);
                        continue block4;
                    }
                    catch (Exception e) {
                        log.error("Did not manage to store data element with id " + dataElement.getId() + " at CMS, continuing...");
                        log.debug("Did not manage to store data element with id " + dataElement.getId() + " because: ", (Throwable)e);
                        ReportManager.manageRecord((String)dataElement.getId(), (String)("Did not manage to store Alternative representation of object with id " + dataElement.getId() + " and content type " + dataElement.getContentType().toString() + " to CMS"), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SINK);
                    }
                }
                break;
            }
            catch (Exception e) {
                log.error("Could not store alternative representations objects in CMS", (Throwable)e);
                break;
            }
        }
        ReportManager.closeReport();
    }

    public boolean isClosed() {
        return this.bridge.isClosed();
    }
}

