/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.handlers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubemodellibrary.elements.BaseInnerElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeAlternative;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElementProperty;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubePart;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.protocol.SMSURLConnection;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.CompoundDataElementImpl;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.DataElementImpl;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.tmpfilemanagement.TempFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSUtils {
    private static Logger log = LoggerFactory.getLogger(CMSUtils.class);
    protected static final int chunkSize = 0x200000;
    protected static final String contenttypeParamsPropertyType = "dts:contenttypeparameters";
    protected static final String customParamsPropertyType = "dts:customparameters";
    private static String tmpSubDir;

    public static ContentType getContentTypeOfObject(GCubeElement gdoc) throws Exception {
        ContentType contentFormat = new ContentType();
        if (gdoc.mimeType() == null) {
            throw new Exception("Mimetype of the object " + gdoc.id() + " is not set");
        }
        contentFormat.setMimeType(gdoc.mimeType());
        Map props = gdoc.properties();
        ArrayList<Parameter> contentTypeParameters = new ArrayList<Parameter>();
        for (GCubeElementProperty prop : props.values()) {
            log.debug("Property - Name: " + prop.key() + " - Value: " + prop.value() + " - Type: " + prop.type());
            if (!prop.type().equals(contenttypeParamsPropertyType)) continue;
            Parameter formatParameter = new Parameter();
            formatParameter.setName(prop.key());
            formatParameter.setValue(prop.value());
            contentTypeParameters.add(formatParameter);
        }
        contentFormat.setContentTypeParameters(contentTypeParameters);
        return contentFormat;
    }

    public static DataElement getDataElementFromCM(GCubeElement gdoc, GCUBEScope scope) throws Exception {
        log.debug("Getting the OID " + gdoc.id() + " completed successfully.");
        ContentType contentType = CMSUtils.getContentTypeOfObject(gdoc);
        DataElementImpl dataElement = DataElementImpl.getSourceDataElement();
        dataElement.setContent(CMSUtils.getContnetStream(gdoc, scope));
        dataElement.setId(gdoc.id());
        dataElement.setContentType(contentType);
        dataElement.setAttribute("ContentOID", gdoc.uri().toString());
        dataElement.setAttribute("DocumentName", gdoc.name());
        return dataElement;
    }

    public static DataElement getDataElementFromAlternativeCM(GCubeAlternative gdoc, GCUBEScope scope) throws Exception {
        log.debug("Getting the OID " + gdoc.id() + " completed successfully.");
        ContentType contentType = CMSUtils.getContentTypeOfObject((GCubeElement)gdoc);
        DataElementImpl dataElement = DataElementImpl.getSourceDataElement();
        dataElement.setContent(CMSUtils.getContnetStream((GCubeElement)gdoc, scope));
        dataElement.setId(gdoc.id());
        dataElement.setContentType(contentType);
        dataElement.setAttribute("ContentOID", gdoc.uri().toString());
        dataElement.setAttribute("DocumentName", gdoc.name());
        return dataElement;
    }

    public static String getObjectsProperty(GCubeDocument gdoc, String PropertyName) {
        Map props = gdoc.properties();
        return ((GCubeElementProperty)props.get(PropertyName)).value();
    }

    public static DataElement getDataElementWithAlternativeRepresentationsFromCM(GCubeDocument gdoc, GCUBEScope scope) throws Exception {
        if (gdoc.alternatives().size() > 0) {
            CompoundDataElementImpl compoundDataElement = new CompoundDataElementImpl();
            compoundDataElement.setId(gdoc.id());
            ContentType contentType = new ContentType();
            contentType.setMimeType("multipart/alternative");
            compoundDataElement.setContentType(contentType);
            compoundDataElement.addPart(CMSUtils.getDataElementFromCM((GCubeElement)gdoc, scope));
            for (GCubeAlternative alternativeRepresentation : gdoc.alternatives()) {
                compoundDataElement.addPart(CMSUtils.getDataElementFromAlternativeCM(alternativeRepresentation, scope));
            }
            return compoundDataElement;
        }
        return CMSUtils.getDataElementFromCM((GCubeElement)gdoc, scope);
    }

    public static DataElement getCompoundDataElementFromCM(GCubeDocument gdoc, GCUBEScope scope) throws Exception {
        if (gdoc.parts().size() > 1) {
            CompoundDataElementImpl compoundDataElement = new CompoundDataElementImpl();
            compoundDataElement.setId(gdoc.id());
            ContentType contentType = new ContentType();
            contentType.setMimeType("multipart/mixed");
            compoundDataElement.setContentType(contentType);
            compoundDataElement.addPart(CMSUtils.getDataElementFromCM((GCubeElement)gdoc, scope));
            for (GCubePart part : gdoc.parts()) {
                log.debug("Part found with id: " + part.id());
                compoundDataElement.addPart(CMSUtils.getDataElementFromCM((GCubeElement)part, scope));
            }
            return compoundDataElement;
        }
        return CMSUtils.getDataElementFromCM((GCubeElement)gdoc, scope);
    }

    public static String storeDataElementToCM(DocumentWriter cmWriter, DataElement object) throws Exception {
        GCubeDocument gdoc = new GCubeDocument();
        gdoc.setName(object.getAttributeValue("DocumentName"));
        gdoc.setBytestream(object.getContent());
        gdoc.setMimeType(object.getContentType().getMimeType());
        if (object.getContentType().getContentTypeParameters() != null && object.getContentType().getContentTypeParameters().size() > 0) {
            for (Parameter fparam : object.getContentType().getContentTypeParameters()) {
                log.debug("Setting the property Name: \"" + fparam.getName() + "\", Value: \"" + fparam.getValue() + "\" to the object " + object.getId());
                GCubeElementProperty prop = new GCubeElementProperty(fparam.getName(), contenttypeParamsPropertyType, fparam.getValue());
                gdoc.properties().put(fparam.getName(), prop);
            }
        }
        return cmWriter.add(gdoc);
    }

    public static void storeDataElementToCMAsAlternativeRepresentation(DocumentWriter cmWriter, GCubeDocument gdoc, DataElement dataElement, String representationRole) throws Exception {
        GCubeAlternative alternative = new GCubeAlternative();
        alternative.setMimeType(dataElement.getContentType().getMimeType());
        alternative.setBytestream(dataElement.getContent());
        alternative.setName(dataElement.getAttributeValue("DocumentName"));
        alternative.setType(representationRole);
        gdoc.trackChanges();
        gdoc.alternatives().add((BaseInnerElement)alternative);
        cmWriter.update(gdoc);
    }

    private static InputStream getContnetStream(GCubeElement document, GCUBEScope scope) throws MalformedURLException, IOException {
        if (document.bytestreamURI() != null) {
            if (document.bytestreamURI().getScheme().equals("sms")) {
                try {
                    return SMSURLConnection.openConnection((URI)document.bytestreamURI(), (String)scope.toString()).getInputStream();
                }
                catch (URISyntaxException e) {
                    log.error("Cannot get stream for metadata, " + document.id(), (Throwable)e);
                    return null;
                }
            }
            return document.bytestreamURI().toURL().openStream();
        }
        if (document.bytestream() != null) {
            byte[] content = document.bytestream();
            ByteArrayInputStream ins = new ByteArrayInputStream(content);
            return ins;
        }
        return null;
    }

    static {
        try {
            tmpSubDir = TempFileManager.genarateTempSubDir();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

