/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementXBean;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSXMLWriter;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.ViewReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.MetadataProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.MetadataView;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeMetadata;
import org.gcube.contentmanagement.gcubemodellibrary.elements.MetadataElements;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.protocol.SMSURLConnection;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCollectionDataSource
implements DataSource,
ContentTypeDataSource {
    private Boolean readFromRS = false;
    private String contentCollectionID;
    private String mCollectionID;
    private RSXMLIterator rsiterator;
    private RSXMLReader rsreader;
    private static Logger log = LoggerFactory.getLogger(MCollectionDataSource.class);
    private static String XMLMimeType = "application/xml";
    private String schemaName;
    private String schemaURI;
    private String language;
    private ViewReader cmReader;
    RemoteIterator<GCubeDocument> metadata = null;
    private boolean isClosed = false;

    public MCollectionDataSource(String input, Parameter[] inputParameters) throws Exception {
        this.mCollectionID = input;
        MetadataView tView = new MetadataView(DTSSManager.getScope());
        tView.setId(this.mCollectionID);
        List views = tView.findSimilar();
        if (views.isEmpty()) {
            throw new Exception("Metadata view not found for ID: " + this.mCollectionID);
        }
        MetadataView view = (MetadataView)views.get(0);
        this.cmReader = view.reader();
        MetadataProjection mp = Projections.metadata();
        this.metadata = this.cmReader.get((Projection)mp);
        this.contentCollectionID = view.collectionId();
        log.debug("ContentCollectionID is found to be " + this.contentCollectionID);
        this.schemaName = view.name();
        this.schemaURI = view.schemaName().toString();
        this.language = view.language();
        String getElementsRS = null;
        if (inputParameters != null && inputParameters.length > 0) {
            for (Parameter param : inputParameters) {
                log.debug("Got Input parameter: " + param.toString());
                if (param.getName() == null || !param.getName().equalsIgnoreCase("getElementsRS")) continue;
                if (param.getValue() != null && param.getValue().trim().length() > 0) {
                    getElementsRS = param.getValue();
                    continue;
                }
                log.warn("Parameter getElementsRS found without having specified properly the value");
            }
        }
        try {
            if (getElementsRS != null) {
                this.readFromRS = true;
                String RSEPR = this.getElementsRS(getElementsRS, this.mCollectionID, this.cmReader);
                log.debug("Some SPECIFIC collection contents are in RS EPR: \n" + RSEPR);
                this.rsreader = RSXMLReader.getRSXMLReader((RSLocator)new RSLocator(RSEPR)).makeLocalPatiently((RSResourceType)new RSResourceLocalType(), 1200000);
                this.rsiterator = this.rsreader.getRSIterator();
            } else {
                this.readFromRS = false;
                log.debug("ALL collection contents\n");
            }
        }
        catch (Exception e) {
            log.error("Failed to retrieve the metadata objects of metadata collection: " + this.mCollectionID, (Throwable)e);
            throw new Exception("Failed to retrieve the metadata objects of metadata collection: " + this.mCollectionID, e);
        }
    }

    private String getElementsRS(String getElementsRS, final String collectionID, final ViewReader metadataReader) throws Exception {
        try {
            RSXMLReader rsWithIDsIreader = RSXMLReader.getRSXMLReader((RSLocator)new RSLocator(getElementsRS)).makeLocalPatiently((RSResourceType)new RSResourceLocalType(), 1200000);
            final RSXMLIterator rsWithIDsIterator = rsWithIDsIreader.getRSIterator();
            final RSXMLWriter rsWithPayloadWriter = RSXMLWriter.getRSXMLWriter();
            new Thread(){

                @Override
                public void run() {
                    int failures = 0;
                    while (rsWithIDsIterator.hasNext()) {
                        try {
                            ResultElementGeneric rselement = (ResultElementGeneric)rsWithIDsIterator.next(ResultElementGeneric.class);
                            String metadataObjectID = rselement.getRecordAttributes("DocID")[0].getAttrValue();
                            log.debug("Managed to get metadata object from result set with id: " + metadataObjectID);
                            MetadataProjection mp = Projections.metadata();
                            GCubeDocument doc = metadataReader.get(metadataObjectID, (Projection)mp);
                            log.trace("Got metadata object: " + doc.id());
                            rsWithPayloadWriter.addResults((ResultElementBase)new ResultElementXBean(metadataObjectID, collectionID, (Object)doc));
                        }
                        catch (Exception e) {
                            log.error("Could not manage result set record", (Throwable)e);
                            if (++failures != 10) continue;
                            log.debug("10 failures occured abording reading result set");
                            break;
                        }
                    }
                    try {
                        log.info("Got all metadata objects from result set with ids, closing result set with the payload");
                        rsWithPayloadWriter.close();
                    }
                    catch (Exception e) {
                        log.error("Did not manage to close result set", (Throwable)e);
                    }
                }
            }.start();
            return rsWithPayloadWriter.getRSLocator((RSResourceType)new RSResourceLocalType()).getLocator();
        }
        catch (Exception e) {
            log.error("Could not read getElementsRS or create writer", (Throwable)e);
            throw new Exception("Could not read getElementsRS or create writer", e);
        }
    }

    public boolean hasNext() {
        if (this.readFromRS.booleanValue()) {
            return this.rsiterator.hasNext();
        }
        log.trace("More documents to process? " + this.metadata.hasNext());
        return this.metadata.hasNext();
    }

    public DataElement next() {
        GCubeDocument doc = null;
        GCubeMetadata metaelement = null;
        String OID = "None";
        try {
            if (this.readFromRS.booleanValue()) {
                ResultElementXBean rselement = (ResultElementXBean)this.rsiterator.next(ResultElementXBean.class);
                doc = (GCubeDocument)rselement.getBean();
            } else {
                log.trace("Reading next metadata document!");
                doc = (GCubeDocument)this.metadata.next();
                MetadataElements elements = doc.metadata();
                if (elements.size() == 0) {
                    log.error("No metadata documents are found for metadata object " + doc.id());
                    throw new Exception("No metadata documents are found for metadata object " + doc.id());
                }
                if (elements.size() > 1) {
                    log.warn("More than one metadata elements for object " + doc.id());
                }
                metaelement = (GCubeMetadata)elements.iterator().next();
                log.trace("Metadata:");
                log.trace(" id: " + metaelement.id());
                log.trace(" mimeType: " + metaelement.mimeType());
                log.trace(" length: " + metaelement.length());
                log.trace(" Metadata info:");
                log.trace("  name: " + metaelement.schemaName());
                log.trace("  schema: " + metaelement.schemaURI());
                log.trace("  language: " + metaelement.language());
            }
            StrDataElement element = StrDataElement.getSourceDataElement();
            element.setId(metaelement.id());
            ContentType contentType = new ContentType();
            contentType.setMimeType(XMLMimeType);
            contentType.addContentTypeParameters(new Parameter[]{new Parameter("schema", this.schemaName), new Parameter("language", this.language), new Parameter("schemaURI", this.schemaURI)});
            element.setContentType(contentType);
            element.setAttribute("schema", this.schemaName);
            element.setAttribute("language", this.language);
            element.setAttribute("schemaURI", this.schemaURI);
            OID = doc.uri().toString();
            String MCID = this.mCollectionID;
            String MOID = metaelement.uri().toString();
            String body = MCollectionDataSource.getContent(metaelement, DTSSManager.getScope());
            log.debug("Got attribute from payload ContentOID - " + OID);
            log.debug("Got attribute from payload MetadataColID - " + MCID);
            log.debug("Got attribute from payload MetadataOID - " + MOID);
            log.debug("Got attribute from view language - " + this.language);
            element.setAttribute("ContentOID", OID);
            element.setAttribute("MetadataColID", MCID);
            element.setAttribute("MetadataOID", MOID);
            element.setAttribute("language", this.language);
            element.setAttribute("ContentCollectionID", this.contentCollectionID);
            log.debug("Set attribute ContentCollectionID " + this.contentCollectionID);
            element.setContent(body);
            ReportManager.manageRecord((String)OID, (String)("Object with id " + OID + ", MOID " + element.getAttributeValue("MetadataOID") + ", ReferencedCOID " + element.getAttributeValue("ContentOID") + " was successfully fetched by RS from MCollection"), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.SOURCE);
            return element;
        }
        catch (Exception e) {
            log.error("Did not manage to get data element from RS", (Throwable)e);
            ReportManager.manageRecord((String)OID, (String)("Object with id " + OID + " could not be fetched by RS from MCollection"), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SOURCE);
            return null;
        }
    }

    public void close() {
        try {
            if (!this.isClosed) {
                this.isClosed = true;
                try {
                    this.rsreader.clear();
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            log.error("Did not manage to clear rs reader", (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String streamToString(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getContent(GCubeMetadata metadata, GCUBEScope scope) throws Exception {
        InputStream instream = MCollectionDataSource.getContnetStream(metadata, scope);
        if (instream == null) {
            throw new Exception("Metadata document " + metadata.id() + " with no content.");
        }
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try {
            int n;
            BufferedReader reader = new BufferedReader(new InputStreamReader(instream, "UTF-8"));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        finally {
            instream.close();
        }
        return ((Object)writer).toString();
    }

    private static InputStream getContnetStream(GCubeMetadata document, GCUBEScope scope) throws MalformedURLException, IOException {
        if (document.bytestreamURI() != null) {
            if (document.bytestreamURI().getScheme().equals("sms")) {
                try {
                    return SMSURLConnection.openConnection((URI)document.bytestreamURI(), (String)scope.toString()).getInputStream();
                }
                catch (URISyntaxException e) {
                    log.error("Cannot get stream for metadata, " + document.id(), (Throwable)e);
                    return null;
                }
            }
            return document.bytestreamURI().toURL().openStream();
        }
        if (document.bytestream() != null) {
            byte[] content = document.bytestream();
            ByteArrayInputStream ins = new ByteArrayInputStream(content);
            return ins;
        }
        return null;
    }

    public ContentType nextContentType() {
        GCubeDocument doc = null;
        try {
            if (this.readFromRS.booleanValue()) {
                this.rsiterator.next(ResultElementXBean.class);
            } else {
                log.trace("Reading next metadata document!");
                doc = (GCubeDocument)this.metadata.next();
                MetadataElements elements = doc.metadata();
                if (elements.size() == 0) {
                    log.error("No metadata documents are found for metadata object " + doc.id());
                    throw new Exception("No metadata documents are found for metadata object " + doc.id());
                }
                if (elements.size() > 1) {
                    log.warn("More than one metadata elements for object " + doc.id());
                }
            }
            ContentType ct = new ContentType();
            ct.setMimeType(XMLMimeType);
            return ct;
        }
        catch (Exception e) {
            log.error("Did not manage to get data element content type from RS", (Throwable)e);
            return null;
        }
    }
}

