/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.util.List;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.contentmanagement.contentmanager.smsplugin.util.GCubeCollections;
import org.gcube.contentmanagement.contentmanager.stubs.CollectionReference;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.datatransformation.datatransformationlibrary.DTSCore;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataBridge;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.handlers.CMSUtils;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.gcube.datatransformation.datatransformationlibrary.statistics.Metric;
import org.gcube.datatransformation.datatransformationlibrary.statistics.StatisticsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionDataSink
extends Thread
implements DataSink {
    private DataBridge bridge = DTSCore.getHardDataBridge();
    private static Logger log = LoggerFactory.getLogger(CollectionDataSink.class);
    private static Metric cmsDataSinkMetric = StatisticsManager.createMetric((String)"CMSDataSinkMetric", (String)"Time to store object to CMS", (StatisticsManager.MetricType)StatisticsManager.MetricType.SINK);
    private String collectionID = null;
    private String collectionName = "DTSCreatedCollection";
    private String collectionDesc = "DTSCreatedCollectionDescription";
    boolean isUserCollection = false;
    boolean isVirtual = false;
    protected static final String PARAMETER_CollectionName = "CollectionName";
    protected static final String PARAMETER_CollectionDesc = "CollectionDesc";
    protected static final String PARAMETER_IsUserCollection = "isUserCollection";
    protected static final String PARAMETER_IsVirtual = "isVirtual";
    private String documentName = "DTSProducedDoc";
    private DocumentWriter cmWriter;

    public CollectionDataSink(String output, Parameter[] outputParameters) throws Exception {
        if (outputParameters != null && outputParameters.length > 0) {
            for (Parameter param : outputParameters) {
                if (param == null || param.getName() == null || param.getValue() == null) continue;
                if (param.getName().equals(PARAMETER_CollectionName)) {
                    if (param.getValue() == null || param.getValue().trim().length() <= 0) continue;
                    this.collectionName = param.getValue();
                    continue;
                }
                if (param.getName().equals(PARAMETER_CollectionDesc)) {
                    if (param.getValue() == null || param.getValue().trim().length() <= 0) continue;
                    this.collectionDesc = param.getValue();
                    continue;
                }
                if (param.getName().equals(PARAMETER_IsUserCollection)) {
                    this.isUserCollection = Boolean.parseBoolean(param.getValue());
                    continue;
                }
                if (!param.getName().equals(PARAMETER_IsVirtual)) continue;
                this.isVirtual = Boolean.parseBoolean(param.getValue());
                log.warn("Is Virtual is depricated. Ignoring it.");
            }
        }
        if (output == null || output.trim().length() == 0) {
            try {
                boolean propagateRequest = true;
                boolean readable = true;
                boolean writable = true;
                List collectionReferences = GCubeCollections.createGCubeCollection((boolean)propagateRequest, (String)this.collectionName, (String)this.collectionDesc, (boolean)this.isUserCollection, (boolean)readable, (boolean)writable, (GCUBEScope)DTSSManager.getScope(), (GCUBESecurityManager[])new GCUBESecurityManager[]{DTSSManager.getSecurityManager()});
                log.debug("Created collections: " + collectionReferences.size());
                String newcolid = ((CollectionReference)collectionReferences.get(0)).getCollectionID();
                CollectionReference newcollectionReference = (CollectionReference)collectionReferences.get(0);
                for (CollectionReference collectionReference : collectionReferences) {
                    log.debug("Collection id: " + collectionReference.getCollectionID());
                }
                if (newcolid == null || newcolid.trim().length() <= 0) {
                    throw new Exception("Could not create new content collection");
                }
                log.info("Managed to create a new collection with id " + newcolid + " and name " + this.collectionName);
                this.collectionID = newcolid;
                this.cmWriter = new DocumentWriter(newcollectionReference, DTSSManager.getScope());
            }
            catch (Exception e) {
                log.error("Could not create new content collection", (Throwable)e);
                throw new Exception("Could not create new content collection");
            }
        } else {
            this.collectionID = output;
        }
        this.start();
    }

    public void append(DataElement object) {
        if (object != null) {
            this.bridge.append(object);
        }
    }

    public void close() {
        this.bridge.close();
    }

    public String getOutput() {
        return this.collectionID;
    }

    @Override
    public void run() {
        block4: while (true) {
            try {
                while (this.bridge.hasNext()) {
                    DataElement object = this.bridge.next();
                    if (object == null) continue;
                    log.debug("Going to store to collection " + this.collectionID + " the object with id " + object.getId() + " and content type " + object.getContentType().toString());
                    try {
                        long startTime = System.currentTimeMillis();
                        if (object.getAttributeValue("DocumentName") == null || object.getAttributeValue("DocumentName").length() == 0) {
                            object.setAttribute("DocumentName", this.documentName);
                        }
                        String storedObjectID = CMSUtils.storeDataElementToCM(this.cmWriter, object);
                        cmsDataSinkMetric.addMeasure(Long.valueOf(System.currentTimeMillis() - startTime));
                        if (storedObjectID == null) {
                            throw new Exception();
                        }
                        ReportManager.manageRecord((String)object.getId(), (String)("Data element with id " + object.getId() + " and content type " + object.getContentType().toString() + " was stored successfully to CMS with id " + storedObjectID), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.SINK);
                        continue block4;
                    }
                    catch (Exception e) {
                        log.error("Did not manage to store data element with id " + object.getId() + " at CMS, continuing...");
                        ReportManager.manageRecord((String)object.getId(), (String)("Did not manage to store data element with id " + object.getId() + " and content type " + object.getContentType().toString() + " to CMS"), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SINK);
                    }
                }
                break;
            }
            catch (Exception e) {
                log.error("Could not store objects in CMS", (Throwable)e);
                break;
            }
        }
        ReportManager.closeReport();
    }

    public boolean isClosed() {
        return this.bridge.isClosed();
    }
}

