/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.UUID;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.common.clients.queries.Query;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.data.streams.Stream;
import org.gcube.data.tml.proxies.TReader;
import org.gcube.data.tml.proxies.TServiceFactory;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.XMLBindings;
import org.gcube.data.trees.patterns.EdgePattern;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;
import org.gcube.datatransformation.datatransformationlibrary.DTSCore;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataBridge;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TMDataSource
implements DataSource,
ContentTypeDataSource {
    private String treeCollectionID;
    private DataBridge bridge = DTSCore.getDataBridge();
    private static Logger log = LoggerFactory.getLogger((String)TMDataSource.class.toString());
    private Stream<Tree> treesReader;

    public TMDataSource(String input, Parameter[] inputParameters) {
        this.treeCollectionID = input;
        log.debug("Going to fetch objects from tree manager with id: " + this.treeCollectionID);
        if (GCUBEScopeManager.DEFAULT.getScope() == null) {
            GCUBEScopeManager.DEFAULT.setScope(DTSSManager.getScope());
        }
        StatefulQuery query = TServiceFactory.readSource().withId(this.treeCollectionID).build();
        TReader treader = (TReader)TServiceFactory.reader().matching((Query)query).build();
        this.treesReader = treader.get((Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.setName("TMDataSourceRetriever");
                File tempIDsStorage = null;
                try {
                    String id;
                    String seperator = UUID.randomUUID().toString();
                    tempIDsStorage = File.createTempFile("DTS", ".tmp");
                    log.info("File storing Trees: " + tempIDsStorage.getName());
                    BufferedWriter out = new BufferedWriter(new FileWriter(tempIDsStorage));
                    int i = 0;
                    while (TMDataSource.this.treesReader.hasNext()) {
                        Tree t = (Tree)TMDataSource.this.treesReader.next();
                        if (++i % 100 == 0) {
                            log.debug("Pre-fetched " + i + " trees.");
                        }
                        out.write(t.uri() + "\n");
                        out.write(XMLBindings.toString((Tree)t) + "\n");
                        out.write(seperator + "\n");
                    }
                    out.close();
                    log.info("Done prefetching trees...");
                    String payload = "";
                    BufferedReader in = new BufferedReader(new FileReader(tempIDsStorage));
                    while ((id = in.readLine()) != null && !id.isEmpty()) {
                        String str = in.readLine();
                        while (!str.equals(seperator)) {
                            payload = payload + str;
                            str = in.readLine();
                        }
                        TMDataSource.this.manageObject(id, payload);
                        payload = "";
                    }
                    in.close();
                    log.info("Removing temp file.");
                    tempIDsStorage.delete();
                }
                catch (Exception e) {
                    log.error("Did not manage to fetch content from cms", (Throwable)e);
                }
                finally {
                    TMDataSource.this.bridge.close();
                }
            }
        }.start();
    }

    public void close() {
        this.bridge.close();
    }

    public boolean isClosed() {
        return this.bridge.isClosed();
    }

    public ContentType nextContentType() {
        DataElement de = this.bridge.next();
        return de == null ? null : de.getContentType();
    }

    public boolean hasNext() {
        return this.bridge.hasNext();
    }

    public DataElement next() {
        return this.bridge.next();
    }

    private void manageObject(String id, String payload) {
        try {
            StrDataElement object = StrDataElement.getSourceDataElement();
            object.setId(id);
            object.setContent(payload);
            object.setAttribute("CollectionID", this.treeCollectionID);
            object.setAttribute("ContentOID", id);
            object.setContentType(new ContentType("application/xml", new ArrayList()));
            this.bridge.append((DataElement)object);
            ReportManager.manageRecord((String)id, (String)("Object with id " + id + " was added for processing by TM"), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.SOURCE);
        }
        catch (Exception e) {
            log.error("Could not manage to fetch the object " + id, (Throwable)e);
            ReportManager.manageRecord((String)id, (String)("Object with id " + id + " could not be fetched TM"), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SOURCE);
        }
    }
}

