/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.RecordAttribute;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSXMLWriter;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSXMLDataSink
implements DataSink {
    private static Logger log = LoggerFactory.getLogger(RSXMLDataSink.class);
    private RSXMLWriter writer = RSXMLWriter.getRSXMLWriter();
    private boolean isClosed = false;

    public RSXMLDataSink(String output, Parameter[] outputParameters) throws Exception {
    }

    private static String stringFromInputStream(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    public void append(DataElement dataElement) {
        ResultElementGeneric rsElem = null;
        try {
            String payload = dataElement instanceof StrDataElement ? ((StrDataElement)dataElement).getStringContent() : RSXMLDataSink.stringFromInputStream(dataElement.getContent());
            rsElem = new ResultElementGeneric("foo", "bar", payload);
        }
        catch (Exception e) {
            log.error("Failed to create ResultSet element", (Throwable)e);
            return;
        }
        dataElement.setAttribute("DocID", dataElement.getAttributeValue("ContentOID"));
        dataElement.setAttribute("CollID", dataElement.getAttributeValue("MetadataColID"));
        dataElement.setAttribute("RankID", "1.0");
        try {
            int i = 0;
            Map attributes = dataElement.getAllAttributes();
            RecordAttribute[] rsAttrs = new RecordAttribute[attributes.size()];
            for (String attrName : attributes.keySet()) {
                log.debug("Setting record attribute: " + attrName + " - " + (String)attributes.get(attrName));
                rsAttrs[i] = new RecordAttribute(attrName, (String)attributes.get(attrName));
                ++i;
            }
            rsElem.setRecordAttributes(rsAttrs);
        }
        catch (Exception e) {
            log.error("Failed to set attributes on the new ResultSet element.", (Throwable)e);
            return;
        }
        try {
            this.writer.addResults((ResultElementBase)rsElem);
            log.debug("Wrote record #" + dataElement.getId());
        }
        catch (Exception e) {
            log.error("Failed to add the new element to the output ResultSet", (Throwable)e);
        }
    }

    public void close() {
        try {
            this.isClosed = true;
            this.writer.close();
            ReportManager.closeReport();
        }
        catch (Exception e) {
            log.error("Could not close RSXMLWriter ", (Throwable)e);
        }
    }

    public String getOutput() {
        try {
            return this.writer.getRSLocator((RSResourceType)new RSResourceWSRFType()).getLocator();
        }
        catch (Exception e) {
            log.error("Did not manage to create the RS Locator", (Throwable)e);
            return null;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

