/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBLOBBase;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSBLOBIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSBLOBReader;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSBLOBWriter;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataBridge;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.RSBlobDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.utils.ResultSetDataElement;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSBlobDataBridge
implements DataBridge {
    private static Logger log = LoggerFactory.getLogger(RSBlobDataSource.class);
    private RSBLOBIterator rsiterator;
    private RSBLOBWriter writer;
    private RSLocator rslocator;
    private boolean isClosed = false;

    public RSBlobDataBridge() {
        try {
            RSBLOBIterator iterator;
            RSLocator locator;
            RSBLOBWriter writer;
            this.writer = writer = RSBLOBWriter.getRSBLOBWriter();
            this.rslocator = locator = writer.getRSLocator((RSResourceType)new RSResourceLocalType());
            RSBLOBReader reader = RSBLOBReader.getRSBLOBReader((RSLocator)locator);
            this.rsiterator = iterator = reader.getRSIterator();
        }
        catch (Exception e) {
            log.error("Could not create local RS writer - reader", (Throwable)e);
        }
    }

    public boolean hasNext() {
        return this.rsiterator.hasNext();
    }

    public DataElement next() {
        ResultSetDataElement rsElement = (ResultSetDataElement)this.rsiterator.next(ResultSetDataElement.class);
        if (rsElement == null) {
            return null;
        }
        return rsElement.getDataElement();
    }

    public ContentType nextContentType() {
        ResultSetDataElement rsElement = (ResultSetDataElement)this.rsiterator.next(ResultSetDataElement.class);
        if (rsElement == null) {
            return null;
        }
        return rsElement.getDataElement().getContentType();
    }

    public void append(DataElement element) {
        if (element == null) {
            return;
        }
        try {
            ResultSetDataElement rsElement = new ResultSetDataElement(element);
            this.writer.addResults((ResultElementBLOBBase)rsElement);
        }
        catch (Exception e) {
            log.error("Could not append object.", (Throwable)e);
        }
    }

    public void close() {
        try {
            if (!this.isClosed && this.writer != null) {
                this.isClosed = true;
                this.writer.close();
            }
        }
        catch (Exception e) {
            log.error("Could not close rsblobwriter", (Throwable)e);
        }
    }

    public String getOutput() {
        if (this.rslocator == null) {
            return null;
        }
        return this.rslocator.getLocator();
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

