/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.io.File;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.LocalFileDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.PathDataSink;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.statistics.StatisticsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathDataSource
implements DataSource,
ContentTypeDataSource {
    private boolean closed = false;
    private int fileCounter = 0;
    private String sinkpath;
    private String[] children;
    private static Logger log = LoggerFactory.getLogger(PathDataSource.class);

    public static void main(String[] args) throws Exception {
        PathDataSource dataSource = new PathDataSource("/tmp/source", null);
        PathDataSink dataSink = new PathDataSink("/tmp/sink", null);
        while (dataSource.hasNext()) {
            try {
                DataElement elm = dataSource.next();
                if (elm == null) continue;
                System.out.println(elm.getContentType().getMimeType());
                System.out.println("Going to store: " + elm.getId());
                dataSink.append(elm);
            }
            catch (Exception e) {
                log.error("Did not manage to append data element to the data sink", (Throwable)e);
            }
        }
        System.out.println("----- Statistics -----");
        System.out.println(StatisticsManager.toXML());
    }

    public PathDataSource(String input, Parameter[] inputParameters) throws Exception {
        this.initializeDistributableDataSource(input, inputParameters);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean hasNext() {
        return this.children != null && this.fileCounter < this.children.length;
    }

    public DataElement next() {
        if (this.children == null || this.fileCounter >= this.children.length) {
            log.warn("Did not manage to get next element...");
            return null;
        }
        String localFileName = this.sinkpath + this.children[this.fileCounter];
        File localFile = new File(localFileName);
        LocalFileDataElement elm = new LocalFileDataElement();
        elm.setAttribute("DocumentName", this.children[this.fileCounter]);
        elm.setContent(localFile);
        elm.setId(this.children[this.fileCounter]);
        ++this.fileCounter;
        return elm;
    }

    public void initializeDistributableDataSource(String input, Parameter[] inputParameters) throws Exception {
        this.sinkpath = input;
        File dir = new File(this.sinkpath);
        if (!this.sinkpath.endsWith(File.pathSeparator)) {
            this.sinkpath = this.sinkpath + File.separator;
        }
        this.children = dir.list();
        if (this.children == null) {
            this.closed = true;
            log.error("Either dir does not exist or is not a directory");
            throw new Exception("Either dir does not exist or is not a directory");
        }
    }

    public void close() {
        this.closed = true;
    }

    public ContentType nextContentType() {
        DataElement de = this.next();
        return de == null ? null : de.getContentType();
    }
}

