/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Locale;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.MetadataView;
import org.gcube.contentmanagement.gcubemodellibrary.elements.BaseInnerElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeMetadata;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.utils.MetadataViewDescription;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCollectionDataSink
implements DataSink {
    private static Logger log = LoggerFactory.getLogger(MCollectionDataSink.class);
    private DocumentWriter cmWriter = null;
    private DocumentReader cmReader = null;
    private String contentColID = null;
    private String outColName = "DTSProducedMCollection";
    private String outColDesc = "DTS Produced Metadata Collection";
    private String outColSchemaName = null;
    private String outColSchemaURI = null;
    private String outColLanguage = null;
    private String outColIsIndexable = "false";
    private String outColIsUser = "false";
    private String outColIsEditable = "false";
    private MetadataView myView = null;
    private Locale locale = null;
    private boolean isClosed = false;

    public MCollectionDataSink(String output, Parameter[] outputParameters) throws Exception {
        if (outputParameters == null || outputParameters.length == 0) {
            log.error("Output Parameters not specified");
            throw new Exception("Output Parameters not specified");
        }
        for (Parameter param : outputParameters) {
            log.debug("Parameter: " + param.toString());
            if (param.getName().equals(MetadataViewDescription.CreationParameters.RELATEDBY_COLLID.toString())) {
                this.contentColID = param.getValue();
                continue;
            }
            if (param.getName().equals(MetadataViewDescription.CreationParameters.COLLECTIONNAME.toString())) {
                this.outColName = param.getValue();
                continue;
            }
            if (param.getName().equals(MetadataViewDescription.CreationParameters.DESCRIPTION.toString())) {
                this.outColDesc = param.getValue();
                continue;
            }
            if (param.getName().equals(MetadataViewDescription.CreationParameters.INDEXABLE.toString())) {
                this.outColIsIndexable = param.getValue();
                continue;
            }
            if (param.getName().equals(MetadataViewDescription.CreationParameters.USER.toString())) {
                this.outColIsUser = param.getValue();
                continue;
            }
            if (param.getName().equals(MetadataViewDescription.CreationParameters.METADATANAME.toString())) {
                this.outColSchemaName = param.getValue();
                continue;
            }
            if (param.getName().equals(MetadataViewDescription.CreationParameters.METADATALANG.toString())) {
                this.outColLanguage = param.getValue();
                continue;
            }
            if (param.getName().equals(MetadataViewDescription.CreationParameters.METADATAURI.toString())) {
                this.outColSchemaURI = param.getValue();
                continue;
            }
            if (!param.getName().equals(MetadataViewDescription.CreationParameters.EDITABLE.toString())) continue;
            this.outColIsEditable = param.getValue();
        }
        this.locale = this.getLocaleFromString(this.outColLanguage);
        if (this.contentColID == null || this.outColSchemaName == null || this.outColSchemaURI == null || this.outColLanguage == null || this.locale == null) {
            log.error("ContentColID, OutColSchemaName OutColSchemaURI or OutColLanguage is not specified");
            throw new Exception("ContentColID, OutColSchemaName OutColSchemaURI or OutColLanguage is not specified");
        }
        this.myView = new MetadataView(DTSSManager.getScope());
        this.myView.setCollectionId(this.contentColID);
        this.myView.setName(this.outColName);
        this.myView.setDescription(this.outColDesc);
        this.myView.setProjection(this.locale, this.outColSchemaName, new URI(this.outColSchemaURI));
        this.myView.setIndexable(true);
        this.myView.setUserCollection(true);
        this.myView.setEditable(true);
        if (this.outColIsIndexable.equalsIgnoreCase("FALSE")) {
            this.myView.setIndexable(false);
        } else if (this.outColIsIndexable.equalsIgnoreCase("TRUE")) {
            this.myView.setIndexable(true);
        }
        if (this.outColIsUser.equalsIgnoreCase("FALSE")) {
            this.myView.setUserCollection(false);
        } else if (this.outColIsUser.equalsIgnoreCase("TRUE")) {
            this.myView.setUserCollection(true);
        }
        if (this.outColIsEditable.equalsIgnoreCase("FALSE")) {
            this.myView.setEditable(false);
        } else if (this.outColIsEditable.equalsIgnoreCase("TRUE")) {
            this.myView.setEditable(true);
        }
        this.myView.publishAndBroadcast();
        String newMetadataCollectionID = this.myView.id();
        if (newMetadataCollectionID == null) {
            log.error("Metadata Collection ID not retrieved. Proceeding with the transformation");
        }
        this.cmReader = new DocumentReader(this.contentColID, DTSSManager.getScope(), DTSSManager.getSecurityManager());
        this.cmWriter = new DocumentWriter(this.contentColID, DTSSManager.getScope(), DTSSManager.getSecurityManager());
        log.info("Managed to create new metadata collection with id " + newMetadataCollectionID);
    }

    private static String stringFromInputStream(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    public void append(DataElement dataElement) {
        if (this.isClosed) {
            return;
        }
        try {
            String payload = dataElement instanceof StrDataElement ? ((StrDataElement)dataElement).getStringContent() : MCollectionDataSink.stringFromInputStream(dataElement.getContent());
            URI metadataObjURI = null;
            String contentOID = null;
            if (dataElement.getAttributeValue("MetadataOID") != null) {
                metadataObjURI = new URI(dataElement.getAttributeValue("MetadataOID"));
                URI gDocURI = URIs.parentURI((URI)metadataObjURI);
                contentOID = URIs.documentID((URI)gDocURI);
            }
            GCubeMetadata metaDocument = new GCubeMetadata();
            metaDocument.setBytestream(payload.getBytes());
            metaDocument.setLanguage(this.locale);
            metaDocument.setSchemaName(this.outColSchemaName);
            metaDocument.setSchemaURI(new URI(this.outColSchemaURI));
            DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
            GCubeDocument doc = this.cmReader.get(contentOID, (Projection)dp);
            doc.metadata().add((BaseInnerElement)metaDocument);
            this.cmWriter.update(doc);
        }
        catch (Exception e) {
            log.error("Failed to append Element");
            ReportManager.manageRecord((String)dataElement.getId(), (String)("Object with id " + dataElement.getId() + ", MOID " + dataElement.getAttributeValue("MetadataOID") + ", ReferencedCOID " + dataElement.getAttributeValue("ContentOID") + " could not be appended to RS for MCollection" + e.getMessage()), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SINK);
        }
    }

    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            try {
                log.debug("Closing the Metadata Manager Sink...");
            }
            catch (Exception e) {
                log.error("Could not close RSXMLWriter ", (Throwable)e);
            }
            try {
                log.debug("The result set must have been send to metadata manager successfully...");
            }
            catch (Exception e) {
                log.error("Could not create RS Locator", (Throwable)e);
            }
            ReportManager.closeReport();
        } else {
            log.error("Trying to close an already closed Metadata Manager data sink...");
        }
    }

    public String getOutput() {
        String newMetadataCollectionID = this.myView.id();
        if (newMetadataCollectionID == null) {
            log.error("Metadata Collection ID not retrieved. Proceeding with the transformation");
        }
        return newMetadataCollectionID;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Locale getLocaleFromString(String localeString) {
        if (localeString == null) {
            return null;
        }
        if ((localeString = localeString.trim()).toLowerCase().equals("default")) {
            return Locale.getDefault();
        }
        int languageIndex = localeString.indexOf(95);
        String language = null;
        if (languageIndex == -1) {
            return new Locale(localeString, "");
        }
        language = localeString.substring(0, languageIndex);
        int countryIndex = localeString.indexOf(95, languageIndex + 1);
        String country = null;
        if (countryIndex == -1) {
            country = localeString.substring(languageIndex + 1);
            return new Locale(language, country);
        }
        country = localeString.substring(languageIndex + 1, countryIndex);
        String variant = localeString.substring(countryIndex + 1);
        return new Locale(language, country, variant);
    }
}

