/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.net.URI;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.handlers.CMSUtils;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CObjectDataSource
implements DataSource,
ContentTypeDataSource {
    private String objectID;
    private DocumentReader cmReader;
    private static Logger log = LoggerFactory.getLogger(CObjectDataSource.class);
    private boolean isClosed = false;

    public CObjectDataSource(String input, Parameter[] inputParameters) {
        String objectURI = input;
        try {
            String collectionID = URIs.collectionID((URI)new URI(objectURI));
            this.cmReader = new DocumentReader(collectionID, DTSSManager.getScope(), DTSSManager.getSecurityManager());
            this.objectID = URIs.documentID((URI)new URI(objectURI));
        }
        catch (Exception e) {
            log.error("Could not initialize data source handler", (Throwable)e);
        }
    }

    public boolean hasNext() {
        return !this.isClosed;
    }

    public DataElement next() {
        if (this.isClosed) {
            return null;
        }
        try {
            this.close();
            DocumentProjection dp = Projections.document();
            GCubeDocument gdoc = this.cmReader.get(this.objectID, (Projection)dp);
            DataElement object = CMSUtils.getDataElementFromCM((GCubeElement)gdoc, DTSSManager.getScope());
            log.debug("Object with id " + this.objectID + " was downloaded successfully from CMS");
            ReportManager.manageRecord((String)this.objectID, (String)("Object with id " + this.objectID + " was downloaded successfully by CMS"), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.SOURCE);
            return object;
        }
        catch (Exception e) {
            log.error("Could not manage to fetch the object " + this.objectID, (Throwable)e);
            this.close();
            ReportManager.manageRecord((String)this.objectID, (String)("Object with id " + this.objectID + " could not be fetched by CMS"), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SOURCE);
            return null;
        }
    }

    public void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public ContentType nextContentType() {
        if (this.isClosed) {
            return null;
        }
        try {
            this.close();
            DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.MIME_TYPE, (Property[])new PropertyTypes.DocumentProperty[0]);
            GCubeDocument gdoc = this.cmReader.get(this.objectID, (Projection)dp);
            ReportManager.manageRecord((String)this.objectID, (String)("Object's content type with id " + this.objectID + " was retrived successfully"), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.SOURCE);
            return CMSUtils.getContentTypeOfObject((GCubeElement)gdoc);
        }
        catch (Exception e) {
            log.error("Could not manage to fetch the object " + this.objectID, (Throwable)e);
            this.close();
            ReportManager.manageRecord((String)this.objectID, (String)("Object with id " + this.objectID + " could not be fetched by CMS"), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SOURCE);
            return null;
        }
    }
}

