/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.File;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.utils.RSDataElementUtil;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRS2DataSource
implements DataSource,
ContentTypeDataSource {
    private static Logger log = LoggerFactory.getLogger(GRS2DataSource.class);
    private RecordDefinition[] defs = null;
    private Boolean hideRecs = false;
    private ForwardReader<GenericRecord> reader = null;
    private boolean isClosed = false;

    public GRS2DataSource(String input, Parameter[] inputParameters) throws Exception {
        this.reader = new ForwardReader(URI.create(input));
        if (inputParameters != null) {
            for (Parameter param : inputParameters) {
                if (param == null || param.getName() == null || param.getValue() == null || !param.getName().equalsIgnoreCase("hideRecs")) continue;
                try {
                    this.hideRecs = Boolean.parseBoolean(param.getValue());
                    log.debug("GRS2DataSource will be set with hideRecs set to " + this.hideRecs);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void close() {
        if (!this.isClosed) {
            try {
                this.isClosed = true;
                log.debug("Total records read: " + this.reader.totalRecords());
                this.reader.close();
                ReportManager.closeReport();
            }
            catch (Exception e) {
                log.error("Could not close ForwardReader ", (Throwable)e);
            }
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean hasNext() {
        try {
            return this.reader.getStatus() != IBuffer.Status.Dispose && (this.reader.getStatus() != IBuffer.Status.Close || this.reader.availableRecords() != 0);
        }
        catch (GRS2ReaderException e) {
            log.warn("Got Exception", (Throwable)e);
            return false;
        }
    }

    public DataElement next() {
        GenericRecord rec = null;
        try {
            rec = (GenericRecord)this.reader.get(60L, TimeUnit.SECONDS);
        }
        catch (GRS2ReaderException e) {
            log.error("Did not manage to read result set element", (Throwable)e);
        }
        if (rec == null) {
            if (this.hasNext()) {
                log.warn("Result set returned null object");
            }
            return null;
        }
        if (this.hideRecs.booleanValue()) {
            rec.hide();
        }
        String metadata = null;
        File f = null;
        try {
            metadata = ((StringField)rec.getField(0)).getPayload();
            try {
                f = ((FileField)rec.getField(1)).getPayload();
                if (this.hideRecs.booleanValue()) {
                    f.deleteOnExit();
                }
            }
            catch (Exception e) {
                f = null;
                log.warn("Data element has no file field.");
            }
        }
        catch (Exception e) {
            log.error("Can't read fields from result set element", (Throwable)e);
        }
        DataElement de = null;
        try {
            de = RSDataElementUtil.dataElementFromRS(metadata, f);
        }
        catch (Exception e) {
            log.error("Can't create data element with the given fields.", (Throwable)e);
        }
        return de;
    }

    public ContentType nextContentType() {
        GenericRecord rec = null;
        try {
            rec = (GenericRecord)this.reader.get(60L, TimeUnit.SECONDS);
        }
        catch (GRS2ReaderException e) {
            log.error("Did not manage to read result set element", (Throwable)e);
        }
        if (rec == null) {
            if (this.hasNext()) {
                log.warn("Result set returned null object");
            }
            return null;
        }
        String metadata = null;
        try {
            metadata = ((StringField)rec.getField(0)).getPayload();
        }
        catch (Exception e) {
            log.error("Can't read fields from result set element", (Throwable)e);
        }
        DataElement de = null;
        try {
            de = RSDataElementUtil.dataElementFromRS(metadata, null);
        }
        catch (Exception e) {
            log.error("Can't create data element with the given fields.", (Throwable)e);
        }
        return de.getContentType();
    }
}

