/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.URIListDataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.statistics.Metric;
import org.gcube.datatransformation.datatransformationlibrary.statistics.StatisticsManager;
import org.gcube.datatransformation.datatransformationlibrary.utils.MimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPDataSink
implements DataSink {
    protected static final String PARAMETER_DirectoryName = "directory";
    protected static final String PARAMETER_Username = "username";
    protected static final String PARAMETER_Password = "password";
    protected static final String PARAMETER_Port = "port";
    private static Metric ftpDataSinkMetric = StatisticsManager.createMetric((String)"FTPDataSinkMetric", (String)"Time to store file to FTP Location", (StatisticsManager.MetricType)StatisticsManager.MetricType.SINK);
    private FTPClient ftpClient = new FTPClient();
    private String server;
    private String username = "anonymous";
    private String password = "anonymous";
    private int port;
    private String output;
    private String directory;
    private boolean isClosed = false;
    private static Logger log = LoggerFactory.getLogger(FTPDataSink.class);

    public static void main(String[] args) throws Exception {
        URIListDataSource uriDataSource = new URIListDataSource("http://dl07.di.uoa.gr:8080/myURIList.txt", null);
        Parameter dir = new Parameter(PARAMETER_DirectoryName, "ftp");
        Parameter username = new Parameter(PARAMETER_Username, "dimitris");
        Parameter password = new Parameter(PARAMETER_Password, "...");
        Parameter[] outputParameters = new Parameter[]{dir, username, password};
        FTPDataSink sink = new FTPDataSink("dl07.di.uoa.gr", outputParameters);
        while (uriDataSource.hasNext()) {
            try {
                DataElement elm = uriDataSource.next();
                if (elm == null) continue;
                sink.append(elm);
            }
            catch (Exception e) {
                log.error("Did not manage to append data element to the data sink", (Throwable)e);
            }
        }
        sink.close();
    }

    public FTPDataSink(String output, Parameter[] outputParameters) throws Exception {
        this.server = output;
        this.port = this.ftpClient.getDefaultPort();
        this.directory = "";
        if (outputParameters != null && outputParameters.length > 0) {
            for (Parameter param : outputParameters) {
                if (param.getName() == null || param.getName().trim().length() <= 0 || param.getValue() == null) continue;
                if (param.getName().equals(PARAMETER_DirectoryName)) {
                    this.directory = param.getValue();
                    if (this.directory.endsWith("/")) continue;
                    this.directory = this.directory + "/";
                    continue;
                }
                if (param.getName().equals(PARAMETER_Username)) {
                    this.username = param.getValue();
                    continue;
                }
                if (param.getName().equals(PARAMETER_Password)) {
                    this.password = param.getValue();
                    continue;
                }
                if (!param.getName().equals(PARAMETER_Port)) continue;
                this.port = Integer.parseInt(param.getValue());
            }
        }
        this.ftpClient.connect(this.server, this.port);
        this.ftpClient.login(this.username, this.password);
        this.ftpClient.setFileType(2);
        log.info("Connected to " + this.server + ".");
        log.info("FTP server replied: " + this.ftpClient.getReplyString());
        int replyCode = this.ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            log.error("FTP server refused connection. Reply CODE: " + replyCode);
            this.ftpClient.disconnect();
            throw new Exception("FTP server refused connection. Reply CODE: " + replyCode);
        }
        output = "ftp://" + this.server + "/" + this.directory;
    }

    public void append(DataElement element) {
        if (element != null && !this.isClosed) {
            String documentName = element.getAttributeValue("DocumentName");
            if (documentName == null) {
                documentName = String.valueOf(element.getId().hashCode());
            }
            String remoteFileName = this.directory + documentName + "." + MimeUtils.getFileExtension((String)element.getContentType().getMimeType());
            int tries = 0;
            while (true) {
                log.debug("Storing element " + element.getId() + " as " + remoteFileName);
                try {
                    InputStream stream = element.getContent();
                    if (stream != null) {
                        long startTime = System.currentTimeMillis();
                        boolean res = this.ftpClient.storeFile(remoteFileName, element.getContent());
                        if (res) {
                            ReportManager.manageRecord((String)element.getId(), (String)("Data element with id " + element.getId() + " and content type " + element.getContentType().toString() + " was stored successfully."), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.SINK);
                        } else {
                            ReportManager.manageRecord((String)element.getId(), (String)("Data element with id " + element.getId() + " and content type " + element.getContentType().toString() + " was not stored."), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SINK);
                        }
                        stream.close();
                        ftpDataSinkMetric.addMeasure(Long.valueOf(System.currentTimeMillis() - startTime));
                    }
                    element.destroy();
                    return;
                }
                catch (Exception e) {
                    if (tries == 3) {
                        log.error("Did not manage to append element in the data sink");
                        ReportManager.manageRecord((String)element.getId(), (String)("Data element with id " + element.getId() + " and content type " + element.getContentType().toString() + " was not stored after 3 tries."), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SINK);
                        return;
                    }
                    ++tries;
                    log.error("Did not manage to append element in the data sink, reconnecting and trying again...", (Throwable)e);
                    try {
                        this.reconnect();
                    }
                    catch (Exception e1) {
                        log.error("Did not manage to reconnect to the ftp site", (Throwable)e1);
                        ReportManager.manageRecord((String)element.getId(), (String)("Data element with id " + element.getId() + " and content type " + element.getContentType().toString() + " was not stored as we could not reconnet to ftp."), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SINK);
                        return;
                    }
                }
            }
        }
    }

    private void reconnect() throws Exception {
        this.ftpClient.connect(this.server, this.port);
        this.ftpClient.login(this.username, this.password);
        this.ftpClient.setFileType(2);
    }

    public void close() {
        this.isClosed = true;
        ReportManager.closeReport();
        if (this.ftpClient.isConnected()) {
            try {
                this.ftpClient.disconnect();
            }
            catch (Exception e) {
                log.error("Did not manage to disconnect from data sink", (Throwable)e);
            }
        }
    }

    public String getOutput() {
        return this.output;
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

