/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.URI;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElement;
import org.gcube.datatransformation.datatransformationlibrary.DTSCore;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.DataElementImpl;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataBridge;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.handlers.CMSUtils;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.gcube.datatransformation.datatransformationlibrary.statistics.Metric;
import org.gcube.datatransformation.datatransformationlibrary.statistics.StatisticsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionDataSource
extends Thread
implements DataSource,
ContentTypeDataSource {
    private String contentCollectionID;
    private DocumentReader cmReader;
    private boolean handleParts = false;
    private boolean handleAlternativeRepresentations = false;
    private DataBridge bridge = DTSCore.getDataBridge();
    private static Logger log = LoggerFactory.getLogger(CollectionDataSource.class);
    private static Metric cmsDataSourceMetric = StatisticsManager.createMetric((String)"CMSDataSourceMetric", (String)"Time to retrieve object from CMS", (StatisticsManager.MetricType)StatisticsManager.MetricType.SOURCE);
    private boolean useOIDs = false;
    private boolean getContentTypesOnly = false;
    private String getElementsRS = null;
    private RSXMLIterator rsiterator;
    private RSXMLReader rsreader;

    public CollectionDataSource(String input, Parameter[] inputParameters) throws Exception {
        log.debug("Going to fetch objects from collection with id: " + input);
        this.contentCollectionID = input;
        if (inputParameters != null) {
            for (Parameter param : inputParameters) {
                if (param == null || param.getName() == null || param.getValue() == null) continue;
                if (param.getName().equalsIgnoreCase("handleParts")) {
                    try {
                        this.handleParts = Boolean.parseBoolean(param.getValue());
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (param.getName().equalsIgnoreCase("handleAlternativeRepresentations")) {
                    try {
                        this.handleAlternativeRepresentations = Boolean.parseBoolean(param.getValue());
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (param.getName().equalsIgnoreCase("useOIDs")) {
                    try {
                        this.useOIDs = Boolean.parseBoolean(param.getValue());
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (param.getName().equalsIgnoreCase("getElementsRS")) {
                    if (param.getValue() != null && param.getValue().trim().length() > 0) {
                        this.getElementsRS = param.getValue();
                        continue;
                    }
                    log.warn("Parameter getElementsRS found without having specified properly the value");
                    continue;
                }
                if (!param.getName().equalsIgnoreCase("getContentTypesOnly")) continue;
                try {
                    this.getContentTypesOnly = Boolean.parseBoolean(param.getValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (this.handleParts && this.handleAlternativeRepresentations) {
            log.error("Cannot handle both parts and alternative representations (currently)");
            throw new Exception("Cannot handle both parts and alternative representations (currently)");
        }
        if (this.getElementsRS != null) {
            log.info("Going to get SPECIFIC elements from collection from result set:\n" + this.getElementsRS);
            try {
                this.rsreader = RSXMLReader.getRSXMLReader((RSLocator)new RSLocator(this.getElementsRS)).makeLocalPatiently((RSResourceType)new RSResourceLocalType(), 1200000);
                this.rsiterator = this.rsreader.getRSIterator();
            }
            catch (Exception e) {
                log.error("Could not get RSXMLIterator ", (Throwable)e);
                throw new Exception("Could not get RSXMLIterator ", e);
            }
        } else {
            log.info("Going to get ALL elements from content collection");
        }
        this.cmReader = new DocumentReader(this.contentCollectionID, DTSSManager.getScope(), DTSSManager.getSecurityManager());
        this.start();
    }

    public boolean hasNext() {
        return this.bridge.hasNext();
    }

    public DataElement next() {
        return this.bridge.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.getContentTypesOnly) {
                DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.MIME_TYPE, (Property[])new PropertyTypes.DocumentProperty[0]);
                RemoteIterator documentIterator = this.cmReader.get((Projection)dp);
                while (documentIterator.hasNext()) {
                    GCubeDocument document = (GCubeDocument)documentIterator.next();
                    DataElementImpl de = DataElementImpl.getSourceDataElement();
                    ContentType ct = new ContentType();
                    ct.setMimeType(document.mimeType());
                    de.setContentType(ct);
                    this.bridge.append((DataElement)de);
                }
            } else if (this.getElementsRS == null) {
                String id;
                File tempIDsStorage = File.createTempFile("DTS", ".tmp");
                log.info("File storing gDoc IDs: " + tempIDsStorage.getName());
                BufferedWriter out = new BufferedWriter(new FileWriter(tempIDsStorage));
                DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
                RemoteIterator documentIterator = this.cmReader.get((Projection)dp);
                int i = 0;
                while (documentIterator.hasNext()) {
                    if (++i % 100 == 0) {
                        log.info("Pre-fetched IDs for " + i + " docs.");
                    }
                    GCubeDocument document = (GCubeDocument)documentIterator.next();
                    out.write(document.id() + "\n");
                }
                out.close();
                log.info("Done prefetching IDs and staff...");
                BufferedReader in = new BufferedReader(new FileReader(tempIDsStorage));
                dp = Projections.document();
                while ((id = in.readLine()) != null && !id.isEmpty()) {
                    GCubeDocument document = this.cmReader.get(id, (Projection)dp);
                    this.manageObject(document);
                }
                in.close();
                log.info("Removing temp file.");
                tempIDsStorage.delete();
            } else {
                while (this.rsiterator.hasNext()) {
                    try {
                        ResultElementGeneric rselement = (ResultElementGeneric)this.rsiterator.next(ResultElementGeneric.class);
                        String objectID = rselement.getRecordAttributes("DocID")[0].getAttrValue();
                        log.trace("Managed to get object from result set with id: " + objectID);
                        if (!this.useOIDs) {
                            URI objURI = new URI(objectID);
                            objectID = URIs.documentID((URI)objURI);
                        }
                        DocumentProjection dp = Projections.document();
                        GCubeDocument document = this.cmReader.get(objectID, (Projection)dp);
                        this.manageObject(document);
                    }
                    catch (Exception e) {
                        log.error("Did not manage to read result set element", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Did not manage to fetch content from cms", (Throwable)e);
        }
        finally {
            this.bridge.close();
        }
    }

    private void manageObject(GCubeDocument document) {
        try {
            long startTime = System.currentTimeMillis();
            DataElement object = this.handleParts ? CMSUtils.getCompoundDataElementFromCM(document, DTSSManager.getScope()) : (this.handleAlternativeRepresentations ? CMSUtils.getDataElementWithAlternativeRepresentationsFromCM(document, DTSSManager.getScope()) : CMSUtils.getDataElementFromCM((GCubeElement)document, DTSSManager.getScope()));
            cmsDataSourceMetric.addMeasure(Long.valueOf(System.currentTimeMillis() - startTime));
            if (object == null) {
                throw new Exception();
            }
            this.bridge.append(object);
            ReportManager.manageRecord((String)document.id(), (String)("Object with id " + document.id() + " was downloaded successfully by CMS"), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.SOURCE);
        }
        catch (Exception e) {
            log.error("Could not manage to fetch the object " + document, (Throwable)e);
            ReportManager.manageRecord((String)document.id(), (String)("Object with id " + document + " could not be fetched by CMS"), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SOURCE);
        }
    }

    public void close() {
        this.bridge.close();
    }

    public boolean isClosed() {
        return this.bridge.isClosed();
    }

    public ContentType nextContentType() {
        return this.bridge.next().getContentType();
    }
}

