/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.UUID;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.datatransformation.datatransformationlibrary.DTSCore;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.DataElementImpl;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeDataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataBridge;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.gcube.datatransformation.datatransformationlibrary.statistics.Metric;
import org.gcube.datatransformation.datatransformationlibrary.statistics.StatisticsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMAggregateDataSource
extends Thread
implements DataSource,
ContentTypeDataSource {
    private String contentCollectionID;
    private DocumentReader cmReader;
    private DataBridge bridge = DTSCore.getDataBridge();
    private static Logger log = LoggerFactory.getLogger(CMAggregateDataSource.class);
    private static Metric cmsDataSourceMetric = StatisticsManager.createMetric((String)"CMSDataSourceMetric", (String)"Time to retrieve object from CMS", (StatisticsManager.MetricType)StatisticsManager.MetricType.SOURCE);

    public CMAggregateDataSource(String input, Parameter[] inputParameters) throws Exception {
        log.debug("Going to fetch objects from collection with id: " + input);
        this.contentCollectionID = input;
        this.cmReader = new DocumentReader(this.contentCollectionID, DTSSManager.getScope(), DTSSManager.getSecurityManager());
        this.start();
    }

    public boolean hasNext() {
        return this.bridge.hasNext();
    }

    public DataElement next() {
        return this.bridge.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File tempIDsStorage = null;
        try {
            String id;
            String seperator = UUID.randomUUID().toString();
            tempIDsStorage = File.createTempFile("DTS", ".tmp");
            log.info("File storing gDoc IDs: " + tempIDsStorage.getName());
            BufferedWriter out = new BufferedWriter(new FileWriter(tempIDsStorage));
            DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
            RemoteIterator documentIterator = this.cmReader.get((Projection)dp);
            int i = 0;
            while (documentIterator.hasNext()) {
                if (++i % 100 == 0) {
                    log.info("Pre-fetched IDs for " + i + " docs.");
                }
                GCubeDocument document = (GCubeDocument)documentIterator.next();
                out.write(document.id() + "\n");
                out.write(document.uri().toString() + "\n");
                out.write(document.name() + "\n");
                out.write(seperator + "\n");
            }
            out.close();
            log.info("Done prefetching IDs and staff...");
            boolean firstline = true;
            BufferedReader in = new BufferedReader(new FileReader(tempIDsStorage));
            while ((id = in.readLine()) != null && !id.isEmpty()) {
                String uri = in.readLine();
                String name = "";
                String str = in.readLine();
                firstline = true;
                while (!str.equals(seperator)) {
                    if (!firstline) {
                        name = name + "\n";
                    }
                    name = name + str;
                    firstline = false;
                    str = in.readLine();
                }
                this.manageObject(id, uri, name);
            }
            in.close();
            log.info("Removing temp file.");
            tempIDsStorage.delete();
        }
        catch (Exception e) {
            log.error("Did not manage to fetch content from cms", (Throwable)e);
        }
        finally {
            this.bridge.close();
        }
    }

    private void manageObject(String id, String uri, String name) {
        try {
            long startTime = System.currentTimeMillis();
            DataElementImpl object = DataElementImpl.getSourceDataElement();
            object.setId(uri);
            log.debug("Reading from CM gdoc with URL: " + uri);
            object.setAttribute("ContentOID", id);
            object.setAttribute("MetadataOID", id);
            object.setAttribute("DocumentName", name);
            object.setAttribute("CollectionID", this.contentCollectionID);
            object.setContentType(new ContentType("application/xml", new ArrayList()));
            cmsDataSourceMetric.addMeasure(Long.valueOf(System.currentTimeMillis() - startTime));
            if (object == null) {
                throw new Exception();
            }
            this.bridge.append((DataElement)object);
            ReportManager.manageRecord((String)id, (String)("Object with id " + id + " was added for processing CMS"), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.SOURCE);
        }
        catch (Exception e) {
            log.error("Could not manage to fetch the object " + uri, (Throwable)e);
            ReportManager.manageRecord((String)id, (String)("Object with id " + id + " could not be fetched by CMS"), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.SOURCE);
        }
    }

    public void close() {
        this.bridge.close();
    }

    public boolean isClosed() {
        return this.bridge.isClosed();
    }

    public ContentType nextContentType() {
        DataElement de = this.bridge.next();
        return de == null ? null : de.getContentType();
    }
}

