/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.adaptors.tree;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.UUID;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.common.clients.queries.Query;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.streams.Stream;
import org.gcube.data.tml.proxies.TReader;
import org.gcube.data.tml.proxies.TServiceFactory;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.XMLBindings;
import org.gcube.data.trees.patterns.EdgePattern;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;
import org.gcube.datatransformation.adaptors.tree.tools.TimeTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCollectionReader {
    private static final Logger logger = LoggerFactory.getLogger(TCollectionReader.class);
    private String collectionID;
    private String collectionName = null;
    private String scope;
    private Object sync = new Object();
    boolean finished;
    String seperator = UUID.randomUUID().toString();
    StatefulQuery query;
    Stream<Tree> treesReader;
    TReader treader;
    private XMLOutputFactory factory;
    private XMLStreamWriter writer;

    public TCollectionReader(String collectionID, String scope) throws IOException {
        this.collectionID = collectionID;
        this.scope = scope;
        ScopeProvider.instance.set(scope);
        this.finished = false;
        this.query = TServiceFactory.readSource().withId(collectionID).build();
        this.treader = (TReader)TServiceFactory.reader().matching((Query)this.query).build();
        this.treesReader = this.treader.get((Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
        this.seperator = UUID.randomUUID().toString();
        this.factory = XMLOutputFactory.newInstance();
    }

    public TCollectionReader(String collectionID, String scope, String collectionName) throws IOException {
        this.collectionID = collectionID;
        this.collectionName = collectionName;
        this.scope = scope;
        ScopeProvider.instance.set(scope);
        this.finished = false;
        this.query = TServiceFactory.readSource().withId(collectionID).build();
        this.treader = (TReader)TServiceFactory.reader().matching((Query)this.query).build();
        this.treesReader = this.treader.get((Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
        this.seperator = UUID.randomUUID().toString();
        this.factory = XMLOutputFactory.newInstance();
    }

    public void readPrintCollections(Writer out) throws XMLStreamException, IOException {
        try {
            this.writer = this.factory.createXMLStreamWriter(out);
            this.writer.writeStartDocument();
            this.writer.writeStartElement("collection");
            this.writer.writeStartElement("name");
            if (this.collectionName == null || this.collectionName.isEmpty() || this.collectionName.equals("")) {
                this.writer.writeCharacters(this.collectionID);
            } else {
                this.writer.writeCharacters(this.collectionName);
            }
            this.writer.writeEndElement();
            this.writer.writeStartElement("provenance");
            this.writer.writeCharacters("Tree Collection");
            this.writer.writeEndElement();
            this.writer.writeStartElement("timestamp");
            this.writer.writeCharacters(TimeTools.getCurrentTimestamp());
            this.writer.writeEndElement();
            this.writer.writeStartElement("records");
            int i = 0;
            while (this.treesReader.hasNext()) {
                Tree t = (Tree)this.treesReader.next();
                this.writer.writeStartElement("record");
                this.writer.writeStartElement("id");
                this.writer.writeCharacters(t.uri().toASCIIString());
                this.writer.writeEndElement();
                this.writer.writeStartElement("fields");
                this.writer.writeStartElement("field");
                this.writer.writeStartElement("name");
                this.writer.writeCharacters("payload");
                this.writer.writeEndElement();
                this.writer.writeStartElement("mimetype");
                this.writer.writeCharacters("text/xml");
                this.writer.writeEndElement();
                this.writer.writeStartElement("payload");
                this.writer.writeCData(XMLBindings.toString((Tree)t));
                this.writer.writeEndElement();
                this.writer.writeEndElement();
                this.writer.writeEndElement();
                this.writer.writeEndElement();
                out.flush();
                logger.debug("Wrote tree #" + ++i + " on the output");
            }
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            out.flush();
        }
        catch (XMLStreamException e) {
            logger.error("Did not manage to write content to output" + e);
        }
        catch (IOException e) {
            System.out.println("IOException occurred during writing to output, closing output stream and returning!");
            out.close();
            return;
        }
        out.flush();
        out.close();
    }

    public void readPrintCollectionsProfiling(PrintWriter out) {
        long start = System.currentTimeMillis();
        try {
            int i = 0;
            while (this.treesReader.hasNext()) {
                this.treesReader.next();
                logger.debug("Read tree #" + ++i + "\tTime Elapsed: " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        catch (Exception e) {
            System.out.println("Did not manage to fetch content from IS" + e);
        }
    }
}

