/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.adaptors.tree;

import com.google.inject.Singleton;
import java.io.IOException;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.gcube.datatransformation.adaptors.common.ElementGenerator;
import org.gcube.datatransformation.adaptors.common.db.exceptions.SourceIDNotFoundException;
import org.gcube.datatransformation.adaptors.common.xmlobjects.TreeResource;
import org.gcube.datatransformation.adaptors.tree.HarvestTrees;
import org.gcube.datatransformation.adaptors.tree.impl.TreeResourceFactory;
import org.gcube.rest.commons.filter.IResourceFilter;
import org.gcube.rest.commons.resourceawareservice.resources.ResourceFactory;
import org.gcube.rest.commons.resourcefile.IResourceFileUtils;
import org.gcube.rest.resourceawareservice.ResourceAwareService;
import org.gcube.rest.resourceawareservice.exceptions.ResourceAwareServiceException;
import org.gcube.rest.resourcemanager.discoverer.Discoverer;
import org.gcube.rest.resourcemanager.publisher.ResourcePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/")
@Singleton
public class HarvestTrees
extends ResourceAwareService<TreeResource> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(HarvestTrees.class);
    private final Discoverer<TreeResource> configDiscoverer;
    private final TreeResourceFactory treeResourceFactory;
    private String scope;
    private String hostname;
    private String port;

    public HarvestTrees(TreeResourceFactory treeResourceFactory, ResourcePublisher<TreeResource> configPublisher, Discoverer<TreeResource> configDiscoverer, IResourceFilter<TreeResource> resourceFilter, IResourceFileUtils<TreeResource> resourceFileUtilsBinary, String hostname, String port, String scope) throws ResourceAwareServiceException {
        super((ResourceFactory)treeResourceFactory, configPublisher, resourceFilter, resourceFileUtilsBinary);
        this.treeResourceFactory = treeResourceFactory;
        this.configDiscoverer = configDiscoverer;
        this.scope = scope;
        this.hostname = hostname;
        this.port = port;
        logger.info("In HarvestTrees constructor");
    }

    @GET
    @Path(value="/HarvestTreeCollection")
    @Produces(value={"text/xml; charset=UTF-8"})
    public Response HarvestTreeCollection(@Context Request request, @HeaderParam(value="gcube-scope") String scopeHeader, @QueryParam(value="treeCollectionID") String treeCollectionID, @QueryParam(value="treeCollectionName") String treeCollectionName) throws IOException, XMLStreamException {
        if (scopeHeader == null || scopeHeader.isEmpty() || treeCollectionID == null || treeCollectionID.isEmpty()) {
            return Response.status((int)400).entity((Object)"Wrong treeCollectionID or scope parameter.").build();
        }
        logger.debug("Requested tree collection with ID: " + treeCollectionID);
        1 out = new /* Unavailable Anonymous Inner Class!! */;
        return Response.ok((Object)out).build();
    }

    @GET
    @Path(value="/AvailableResources")
    @Produces(value={"application/xml; charset=UTF-8"})
    public Response AvailableResources() throws ParserConfigurationException, TransformerException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element rootElement = doc.createElement("Resources");
        for (TreeResource treeResource : this.getAllResources()) {
            Element resource = doc.createElement("resource");
            for (String treeID : treeResource.getTreeIDs()) {
                Element id = doc.createElement("treeID");
                id.appendChild(doc.createTextNode(treeID));
                resource.appendChild(id);
            }
            rootElement.appendChild(resource);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ElementGenerator.domToXML((Element)rootElement)).build();
    }

    @GET
    @Path(value="/ResetResource")
    @Produces(value={"text/plain; charset=UTF-8"})
    public Response ResetResource(@HeaderParam(value="gcube-scope") String scopeHeader) throws SourceIDNotFoundException, Exception {
        for (TreeResource treeResource : this.getAllResources()) {
            this.destroyResource(treeResource.getResourceID());
            logger.debug("Deleted tree resource with ID: " + treeResource.getResourceID());
        }
        String resourceID = this.createResource("");
        logger.debug("created resource with id: " + resourceID);
        return Response.status((int)201).entity((Object)"Created successfully the resource").build();
    }

    @GET
    @Path(value="/AddTree")
    @Produces(value={"text/plain; charset=UTF-8"})
    public Response AddTree(@HeaderParam(value="gcube-scope") String scopeHeader, @FormParam(value="treeID") String treeID) throws SourceIDNotFoundException, Exception {
        if (treeID == null) {
            return Response.status((int)400).entity((Object)"Parameter treeID is missing!").build();
        }
        for (TreeResource treeResource : this.getAllResources()) {
            if (treeResource.getTreeIDs().contains(treeID)) continue;
            treeResource.addTreeID(treeID);
            this.saveResource(treeResource.getResourceID());
        }
        return Response.status((int)200).build();
    }

    @GET
    @Path(value="/RemoveTree")
    @Produces(value={"text/plain; charset=UTF-8"})
    public Response RemoveTree(@HeaderParam(value="gcube-scope") String scopeHeader, @FormParam(value="treeID") String treeID) throws SourceIDNotFoundException, Exception {
        if (treeID == null) {
            return Response.status((int)400).entity((Object)"Parameter treeID is missing!").build();
        }
        for (TreeResource treeResource : this.getAllResources()) {
            treeResource.removeTreeID(treeID);
            this.saveResource(treeResource.getResourceID());
        }
        return Response.status((int)200).build();
    }

    public String getResourceClass() {
        return "HarvesterResource";
    }

    public String getResourceNamePref() {
        return "TreeResource";
    }

    public String getScope() {
        return this.scope;
    }
}

