/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.adaptors.discoverer;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.gcube.datatransformation.adaptors.common.db.discover.DBPropsDiscoverer;
import org.gcube.datatransformation.adaptors.discoverer.AdaptorsDiscoverer;
import org.gcube.rest.resourcemanager.discoverer.ri.RunningInstancesDiscoverer;
import org.gcube.rest.resourcemanager.harvester.IResourceHarvester;
import org.gcube.rest.resourcemanager.harvester.ResourceHarvester;
import org.gcube.rest.resourcemanager.is.discoverer.ri.icclient.RIDiscovererISimpl;

public class ManagerHelper {
    private String scope;
    private DBPropsDiscoverer dbDiscoverer;

    public ManagerHelper(String scope) {
        this.scope = scope;
        this.dbDiscoverer = new DBPropsDiscoverer((RunningInstancesDiscoverer)new RIDiscovererISimpl(), (IResourceHarvester)new ResourceHarvester());
    }

    public Set<String> getDBRunningInstancesEps() {
        return this.dbDiscoverer.discoverDBServiceRunningInstances(this.scope);
    }

    public List<AdaptorsDiscoverer.Info> getAllDBProps(String endpoint) throws ClientProtocolException, IOException {
        AdaptorsDiscoverer disc = new AdaptorsDiscoverer(this.scope);
        return disc.queryForDBProps(endpoint);
    }

    public String getDBPropsXML(String endpoint, String sourcename, String propsname) throws IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(endpoint + "/GetResource?sourcename=" + sourcename + "&propsname=" + propsname);
        httpget.addHeader("gcube-scope", this.scope);
        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        if (response.getStatusLine().getStatusCode() != 200) {
            return "";
        }
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    public int setDBPropsXML(String endpoint, String dbPropsXML) throws Exception {
        String inputLine;
        URL obj = new URL(endpoint);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        con.setRequestProperty("gcube-scope", this.scope);
        con.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(con.getOutputStream());
        wr.writeBytes("/ReplaceDBHarvesterConfig?dbPropsXML=" + dbPropsXML);
        wr.flush();
        wr.close();
        int responseCode = con.getResponseCode();
        System.out.println("Response Code : " + responseCode);
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        System.out.println(response.toString());
        return responseCode;
    }
}

