/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.adaptors.discoverer;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.gcube.datatransformation.adaptors.common.db.discover.DBPropsDiscoverer;
import org.gcube.datatransformation.adaptors.common.tree.discover.TreeResourceDiscoverer;
import org.gcube.rest.resourcemanager.discoverer.ri.RunningInstancesDiscoverer;
import org.gcube.rest.resourcemanager.harvester.IResourceHarvester;
import org.gcube.rest.resourcemanager.harvester.ResourceHarvester;
import org.gcube.rest.resourcemanager.is.discoverer.ri.icclient.RIDiscovererISimpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AdaptorsDiscoverer {
    private String scope;
    private DBPropsDiscoverer dbDiscoverer;
    private TreeResourceDiscoverer treeDiscoverer;

    public static void main(String[] args) throws IOException {
    }

    public AdaptorsDiscoverer(String scope) {
        this.scope = scope;
    }

    public List<String> discoverTreeEps() throws IOException {
        this.treeDiscoverer = new TreeResourceDiscoverer((RunningInstancesDiscoverer)new RIDiscovererISimpl(), (IResourceHarvester)new ResourceHarvester());
        ArrayList<String> endpoints = new ArrayList<String>();
        for (String ept : this.treeDiscoverer.discoverTreeServiceRunningInstances(this.scope)) {
            for (String treeID : this.queryForTreeProps(ept)) {
                endpoints.add(ept + "/HarvestTreeCollection?treeCollectionID=" + treeID);
            }
        }
        return endpoints;
    }

    private List<String> queryForTreeProps(String endpoint) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        return output;
    }

    public List<String> discoverAllDBEps() throws IOException {
        this.dbDiscoverer = new DBPropsDiscoverer((RunningInstancesDiscoverer)new RIDiscovererISimpl(), (IResourceHarvester)new ResourceHarvester());
        ArrayList<String> endpoints = new ArrayList<String>();
        for (String ept : this.dbDiscoverer.discoverDBServiceRunningInstances(this.scope)) {
            for (Info info : this.queryForDBProps(ept)) {
                endpoints.add(ept + "/HarvestDatabase?sourcename=" + info.sourcename + "&propsname=" + info.propsname);
            }
        }
        return endpoints;
    }

    public List<String> discoverDBEps(String hostUri) throws IOException {
        URL hostUrl;
        this.dbDiscoverer = new DBPropsDiscoverer((RunningInstancesDiscoverer)new RIDiscovererISimpl(), (IResourceHarvester)new ResourceHarvester());
        try {
            hostUrl = new URL(hostUri);
        }
        catch (MalformedURLException e) {
            throw new MalformedURLException("The provided host is not an understandable URL");
        }
        ArrayList<String> endpoints = new ArrayList<String>();
        try {
            for (String ept : this.dbDiscoverer.discoverDBServiceRunningInstances(this.scope)) {
                URL eptUrl = new URL(ept);
                if (!eptUrl.getHost().equalsIgnoreCase(hostUrl.getHost())) continue;
                for (Info info : this.queryForDBProps(ept)) {
                    endpoints.add(ept + "/HarvestDatabase?sourcename=" + info.sourcename + "&propsname=" + info.propsname);
                }
            }
        }
        catch (MalformedURLException malformed) {
            throw new MalformedURLException("Some of the discovered endpoints do not have an understandable URL");
        }
        return endpoints;
    }

    public List<String> discoverAllDBEps(String sourcename, String propsname) throws IOException {
        this.dbDiscoverer = new DBPropsDiscoverer((RunningInstancesDiscoverer)new RIDiscovererISimpl(), (IResourceHarvester)new ResourceHarvester());
        ArrayList<String> endpoints = new ArrayList<String>();
        for (String ept : this.dbDiscoverer.discoverDBServiceRunningInstances(this.scope)) {
            for (Info info : this.queryForDBProps(ept)) {
                if (!info.getSourcename().equals(sourcename) || !info.getPropsname().equals(propsname)) continue;
                endpoints.add(ept + "/HarvestDatabase?sourcename=" + info.sourcename + "&propsname=" + info.propsname);
            }
        }
        return endpoints;
    }

    public List<Info> queryForDBProps(String endpoint) throws IOException {
        ArrayList<Info> output = new ArrayList<Info>();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(endpoint + "/AvailableResources");
        httpget.addHeader("gcube-scope", this.scope);
        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        if (response.getStatusLine().getStatusCode() != 200) {
            return output;
        }
        HttpEntity entity = response.getEntity();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(entity.getContent());
            NodeList resources = doc.getElementsByTagName("resource");
            for (int i = 0; i < resources.getLength(); ++i) {
                Node nNode = resources.item(i);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                output.add(new Info(eElement.getElementsByTagName("sourcename").item(0).getTextContent(), eElement.getElementsByTagName("propsname").item(0).getTextContent()));
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return output;
    }

    class Info {
        private String sourcename;
        private String propsname;

        public Info(String sourcename, String propsname) {
            this.sourcename = sourcename;
            this.propsname = propsname;
        }

        public String getSourcename() {
            return this.sourcename;
        }

        public void setSourcename(String sourcename) {
            this.sourcename = sourcename;
        }

        public String getPropsname() {
            return this.propsname;
        }

        public void setPropsname(String propsname) {
            this.propsname = propsname;
        }
    }
}

