/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.adaptors.common.db.tools;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.gcube.datatransformation.adaptors.common.db.exceptions.SourceIDNotFoundException;
import org.gcube.datatransformation.adaptors.common.db.xmlobjects.DBProps;
import org.gcube.datatransformation.adaptors.common.db.xmlobjects.DBSource;
import org.gcube.datatransformation.adaptors.common.db.xmlobjects.Edge;
import org.gcube.datatransformation.adaptors.common.db.xmlobjects.Table;

public class SourcePropsTools {
    public static String getSqlOfTable(DBProps dbProps, String tableName) {
        for (Table table : dbProps.getTables()) {
            if (!table.getName().equalsIgnoreCase(tableName)) continue;
            return table.getSql();
        }
        return "";
    }

    public static String getPKeyOfTable(DBProps dbProps, String tableName) {
        for (Edge edge : dbProps.getEdges()) {
            if (!edge.getParent().equalsIgnoreCase(tableName)) continue;
            return edge.getPKeys();
        }
        return "";
    }

    public static ArrayList<String> getChildrenOfTable(DBProps dbProps, String tableName) {
        ArrayList<String> children = new ArrayList<String>();
        for (Edge edge : dbProps.getEdges()) {
            if (!edge.getParent().equalsIgnoreCase(tableName)) continue;
            children.add(edge.getChild());
        }
        return children;
    }

    public static ArrayList<Edge> getEdges(DBProps dbProps, String parentTableName) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Edge edge : dbProps.getEdges()) {
            if (!edge.getParent().equalsIgnoreCase(parentTableName)) continue;
            edges.add(edge);
        }
        return edges;
    }

    public static DBProps parseSourceProps(String propsXML) throws SourceIDNotFoundException, Exception {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DBProps.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(propsXML);
            return (DBProps)((Object)jaxbUnmarshaller.unmarshal((Reader)reader));
        }
        catch (JAXBException e) {
            throw new Exception(new Throwable("Error upon unmarshalling the properties XML", e));
        }
    }

    public static DBSource parseDBSource(String dbSourceXML) throws SourceIDNotFoundException, Exception {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DBProps.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(dbSourceXML);
            return (DBSource)jaxbUnmarshaller.unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            throw new Exception(new Throwable("Error upon unmarshalling the properties XML", e));
        }
    }

    public static String dbPropsToXML(DBProps dbProps) throws SourceIDNotFoundException, Exception {
        Marshaller jaxbMarshaller = JAXBContext.newInstance((Class[])new Class[]{DBProps.class}).createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter sw = new StringWriter();
        jaxbMarshaller.marshal((Object)dbProps, (Writer)sw);
        return sw.toString();
    }

    public static String isValid(DBProps dbProps) {
        int rootNum = 0;
        for (Table table : dbProps.getTables()) {
            boolean root = true;
            int numChild = 0;
            for (Edge edge : dbProps.getEdges()) {
                if (!table.getName().equalsIgnoreCase(edge.getChild())) continue;
                ++numChild;
                root = false;
            }
            if (numChild > 1) {
                return "Table " + table.getName() + " is child of more than 1 table. That's not allowed.";
            }
            if (!root) continue;
            ++rootNum;
        }
        if (rootNum != 1) {
            return "Number of root tables is not exactly 1";
        }
        return "valid";
    }
}

