/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.utils;

import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class HTTPCall {
    protected static final String USER_AGENT_KEY = "User-Agent";
    protected static final String USER_AGENT_NAME = "gCat";
    protected final String address;
    protected boolean gCubeTargetService;

    public boolean isgCubeTargetService() {
        return this.gCubeTargetService;
    }

    public void setgCubeTargetService(boolean gCubeTargetService) {
        this.gCubeTargetService = gCubeTargetService;
    }

    public HTTPCall(String address) {
        this(address, USER_AGENT_NAME);
    }

    protected HTTPCall(String address, String userAgent) {
        this.address = address;
        this.gCubeTargetService = true;
    }

    protected URL getURL(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        if (url.getProtocol().compareTo("https") == 0) {
            url = new URL(url.getProtocol(), url.getHost(), url.getDefaultPort(), url.getFile());
        }
        return url;
    }

    public URL getFinalURL(URL url) {
        try {
            URL finalURL = url;
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(false);
            connection.setRequestProperty(USER_AGENT_KEY, USER_AGENT_NAME);
            int responseCode = connection.getResponseCode();
            if (responseCode >= Response.Status.BAD_REQUEST.getStatusCode()) {
                Response.Status status = Response.Status.fromStatusCode((int)responseCode);
                String responseMessage = connection.getResponseMessage();
                throw new WebApplicationException(responseMessage, status);
            }
            if (responseCode == 302 || responseCode == 301 || responseCode == 303 || responseCode == Response.Status.TEMPORARY_REDIRECT.getStatusCode() || responseCode == 308) {
                finalURL = this.getURL(connection.getHeaderField("Location"));
                finalURL = this.getFinalURL(finalURL);
            }
            return finalURL;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }
}

