/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.service.engine.impl;

import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import org.gcube.data.publishing.gCatFeeder.service.engine.CatalogueControllersManager;
import org.gcube.data.publishing.gCatFeeder.service.engine.CollectorsManager;
import org.gcube.data.publishing.gCatFeeder.service.engine.ExecutionManager;
import org.gcube.data.publishing.gCatFeeder.service.engine.FeederEngine;
import org.gcube.data.publishing.gCatFeeder.service.engine.PersistenceManager;
import org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence.DBQueryDescriptor;
import org.gcube.data.publishing.gCatFeeder.service.model.ExecutionDescriptor;
import org.gcube.data.publishing.gCatFeeder.service.model.ExecutionRequest;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.CollectorNotFound;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.DescriptorNotFound;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.ElementNotFound;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.InvalidRequest;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.PersistenceError;

public class FeederEngineImpl
implements FeederEngine {
    @Inject
    private ExecutionManager executions;
    @Inject
    private CollectorsManager collectors;
    @Inject
    private CatalogueControllersManager catalogues;
    @Inject
    private PersistenceManager persistence;

    public ExecutionDescriptor submit(ExecutionRequest req) throws InternalError, PersistenceError, InvalidRequest {
        try {
            this.verifyRequest(req);
            ExecutionDescriptor related = this.persistence.create(req);
            this.executions.submit(related);
            return related;
        }
        catch (CollectorNotFound | DescriptorNotFound e) {
            throw new InvalidRequest(e);
        }
    }

    public Collection<ExecutionDescriptor> get(DBQueryDescriptor filter) throws PersistenceError, InvalidRequest {
        return this.persistence.get(filter);
    }

    public ExecutionDescriptor getById(Long id) throws PersistenceError, ElementNotFound, InvalidRequest {
        return this.persistence.getById(id);
    }

    private void verifyRequest(ExecutionRequest request) throws InternalError, CollectorNotFound, DescriptorNotFound {
        Set availableControllers = this.catalogues.getAvailableControllers();
        if (request.getToInvokeControllers().size() == 1 && request.getToInvokeControllers().contains("ALL")) {
            request.setToInvokeControllers(availableControllers);
        }
        for (String requestedCatalogue : request.getToInvokeControllers()) {
            if (availableControllers.contains(requestedCatalogue)) continue;
            throw new DescriptorNotFound("Requested catalogue controller " + requestedCatalogue + " not found.");
        }
        Set availableCollectors = this.collectors.getAvailableCollectors();
        if (request.getToInvokeCollectors().size() == 1 && request.getToInvokeCollectors().contains("ALL")) {
            request.setToInvokeCollectors(availableCollectors);
        }
        for (String requestedCollector : request.getToInvokeCollectors()) {
            if (availableCollectors.contains(requestedCollector)) continue;
            throw new DescriptorNotFound("Requested collector " + requestedCollector + " not found.");
        }
    }
}

