/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.service.engine.impl;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.gcube.data.publishing.gCatFeeder.service.engine.CollectorsManager;
import org.gcube.data.publishing.gCatFeeder.service.engine.Infrastructure;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.CollectorNotFound;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.InternalError;
import org.gcube.data.publishing.gCatfeeder.collectors.CollectorPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorsManagerImpl
implements CollectorsManager {
    private static final Logger log = LoggerFactory.getLogger(CollectorsManagerImpl.class);
    private ServiceLoader<CollectorPlugin> collectorPluginsLoader = null;
    private ConcurrentHashMap<String, CollectorPlugin> availablePlugins = new ConcurrentHashMap();
    @Inject
    private Infrastructure infrastructure;

    @PostConstruct
    public void post() {
        log.debug("Loading collector plugins...");
        this.collectorPluginsLoader = ServiceLoader.load(CollectorPlugin.class);
        for (CollectorPlugin collectorPlugin : this.collectorPluginsLoader) {
            log.debug("Loading {} ", collectorPlugin.getClass());
            log.debug("Descriptor {} ", (Object)collectorPlugin.getDescriptor());
            this.availablePlugins.put(collectorPlugin.getDescriptor().getName(), collectorPlugin);
        }
        log.trace("Loaded {} collector plugins ", (Object)this.availablePlugins.size());
        log.trace("Static initialization...");
        for (Map.Entry entry : this.availablePlugins.entrySet()) {
            log.debug("Static initialization for : {} ", entry.getKey());
            try {
                ((CollectorPlugin)entry.getValue()).init();
            }
            catch (Throwable t) {
                log.error("Unexpected exception while initializing {} ", entry.getKey(), (Object)t);
            }
        }
    }

    public Set<String> getAvailableCollectors() {
        return this.availablePlugins.keySet();
    }

    public CollectorPlugin<?> getPluginById(String collectorId) throws CollectorNotFound {
        if (this.availablePlugins.containsKey(collectorId)) {
            return (CollectorPlugin)this.availablePlugins.get(collectorId);
        }
        throw new CollectorNotFound("Collector plugin " + collectorId + " not available.");
    }

    public void initInScope() throws InternalError {
        log.trace("Initialization under scope {} ", (Object)this.infrastructure.getCurrentContext());
        for (Map.Entry entry : this.availablePlugins.entrySet()) {
            log.debug("Scope initialization for : {} ", entry.getKey());
            try {
                ((CollectorPlugin)entry.getValue()).initInScope();
            }
            catch (Throwable t) {
                log.error("Unexpected exception while initializing {} ", entry.getKey(), (Object)t);
            }
        }
    }
}

