/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.service.rest;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.data.publishing.gCatFeeder.service.GCatFeederManager;
import org.gcube.data.publishing.gCatFeeder.service.engine.FeederEngine;
import org.gcube.data.publishing.gCatFeeder.service.engine.Infrastructure;
import org.gcube.data.publishing.gCatFeeder.service.engine.impl.persistence.DBQueryDescriptor;
import org.gcube.data.publishing.gCatFeeder.service.model.ExecutionDescriptor;
import org.gcube.data.publishing.gCatFeeder.service.model.ExecutionRequest;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.ElementNotFound;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.InvalidRequest;
import org.gcube.data.publishing.gCatFeeder.service.model.fault.PersistenceError;
import org.gcube.data.publishing.gCatFeeder.service.rest.Executions;
import org.gcube.smartgears.annotations.ManagedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedBy(value=GCatFeederManager.class)
@Path(value="execution")
public class Executions {
    private static final Logger log = LoggerFactory.getLogger(Executions.class);
    @Inject
    private FeederEngine engine;
    @Inject
    private Infrastructure infrastructure;

    @POST
    @Produces(value={"application/json"})
    public ExecutionDescriptor submit(@Context UriInfo info) {
        try {
            ExecutionRequest request = new ExecutionRequest();
            if (info.getQueryParameters().containsKey((Object)"harvester")) {
                for (String collector : (List)info.getQueryParameters().get((Object)"harvester")) {
                    request.addCollectorId(collector);
                }
            } else {
                request.addCollectorId("ALL");
            }
            if (info.getQueryParameters().containsKey((Object)"controller")) {
                for (String catalogue : (List)info.getQueryParameters().get((Object)"controller")) {
                    request.addControllerId(catalogue);
                }
            } else {
                request.addControllerId("ALL");
            }
            String token = this.infrastructure.getCurrentToken();
            request.setCallerID(this.infrastructure.getClientID(token));
            request.setContext(this.infrastructure.getCurrentContext());
            request.setEncryptedToken(this.infrastructure.encrypt(token));
            log.trace("Submitting request {} ", (Object)request);
            ExecutionDescriptor toReturn = this.engine.submit(request);
            log.debug("Returning {} ", (Object)toReturn);
            return toReturn;
        }
        catch (PersistenceError e) {
            log.warn("Unexpected Exception while talking to persistnce", (Throwable)e);
            throw new WebApplicationException("Invalid Request.", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (InvalidRequest e) {
            log.warn("Unexpected Exception ", (Throwable)e);
            throw new WebApplicationException("Invalid Request.", (Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (Throwable t) {
            log.warn("Unexpected Exception ", t);
            throw new WebApplicationException("Unexpected Exception.", t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAll() {
        try {
            String token = SecurityTokenProvider.instance.get();
            log.debug("Requested getALL with token {} ", (Object)token);
            DBQueryDescriptor filter = new DBQueryDescriptor();
            Collection toReturn = this.engine.get(filter);
            1 entity = new /* Unavailable Anonymous Inner Class!! */;
            return Response.ok((Object)entity).build();
        }
        catch (PersistenceError e) {
            log.warn("Unexpected Exception while talking to persistnce", (Throwable)e);
            throw new WebApplicationException("Invalid Request.", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (InvalidRequest e) {
            log.warn("Unexpected Exception ", (Throwable)e);
            throw new WebApplicationException("Invalid Request.", (Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (Throwable t) {
            log.warn("Unexpected Exception ", t);
            throw new WebApplicationException("Unexpected Exception.", t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{executionId}")
    public ExecutionDescriptor get(@PathParam(value="executionId") Long executionId) {
        try {
            return this.engine.getById(executionId);
        }
        catch (PersistenceError e) {
            log.warn("Unexpected Exception while talking to persistnce", (Throwable)e);
            throw new WebApplicationException("Invalid Request.", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (ElementNotFound e) {
            log.warn("Unexpected Exception ", (Throwable)e);
            throw new WebApplicationException("Descriptor not found for " + executionId, (Throwable)e, Response.Status.NOT_FOUND);
        }
        catch (InvalidRequest e) {
            log.warn("Unexpected Exception ", (Throwable)e);
            throw new WebApplicationException("Invalid Request.", (Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (Throwable t) {
            log.warn("Unexpected Exception ", t);
            throw new WebApplicationException("Unexpected Exception.", t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

