/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCataFeeder.catalogues.gCat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.ws.rs.WebApplicationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.data.publishing.gCatFeeder.catalogues.CatalogueController;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.PublishReport;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.faults.CatalogueInteractionException;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.faults.ControllerInstantiationFault;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.faults.PublicationException;
import org.gcube.data.publishing.gCatFeeder.catalogues.model.faults.WrongObjectFormatException;
import org.gcube.data.publishing.gCatFeeder.model.CatalogueFormatData;
import org.gcube.data.publishing.gCatFeeder.model.CatalogueInstanceDescriptor;
import org.gcube.data.publishing.gCatFeeder.model.ControllerConfiguration;
import org.gcube.data.publishing.gCatFeeder.model.InternalConversionException;
import org.gcube.gcat.client.Item;
import org.gcube.gcat.client.Profile;
import org.gcube.gcat.client.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class GCatController
implements CatalogueController {
    private static final Logger log = LoggerFactory.getLogger(GCatController.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder builder;
    private static XPathFactory xPathfactory;
    private static XPath xpath;
    private static XPathExpression expr;
    private CatalogueInstanceDescriptor desc;
    private String callerToken = null;
    private ControllerConfiguration config;

    public GCatController(CatalogueInstanceDescriptor instance) throws ControllerInstantiationFault {
        this.desc = instance;
        if (this.isCustomToken()) {
            this.setCustomToken();
        }
        this.checkInstance();
        if (this.isCustomToken()) {
            this.resetToken();
        }
        this.config = new ControllerConfiguration();
        this.config.setOnClash(ControllerConfiguration.PublishingPolicy.UPDATE);
    }

    public void configure(ControllerConfiguration config) {
        this.config = config;
    }

    public PublishReport publishItem(CatalogueFormatData arg0) throws WrongObjectFormatException, CatalogueInteractionException, PublicationException, InternalConversionException {
        log.debug("Publishing {} ", (Object)arg0);
        String serialized = arg0.toCatalogueFormat();
        try {
            if (this.isCustomToken()) {
                this.setCustomToken();
            }
            log.debug("Parsing data..");
            JsonNode node = mapper.readTree(serialized);
            if (!node.hasNonNull("item")) {
                throw new WrongObjectFormatException("No \"item\" specified in serialized object");
            }
            JsonNode itemNode = node.path("item");
            if (node.hasNonNull("profile")) {
                log.debug("Publishing profile..");
                String xmlProfile = node.path("profile").asText();
                String profileName = GCatController.getProfileName(xmlProfile);
                this.createProfile(profileName, xmlProfile);
            }
            log.debug("Publishing Item..");
            String itemResp = this.createItem(itemNode.toString(), itemNode.path("name").textValue());
            String itemId = GCatController.getId(itemResp);
            log.debug("Pubilshed Item with ID {} ", (Object)itemId);
            if (node.hasNonNull("resources")) {
                log.debug("Pubilshing resources for {} ", (Object)itemId);
                Iterator resIterator = node.path("resources").elements();
                while (resIterator.hasNext()) {
                    JsonNode resNode = (JsonNode)resIterator.next();
                    String resourceName = resNode.path("name").textValue();
                    this.createResource(itemId, resourceName, resNode.toString());
                }
            }
            PublishReport publishReport = new PublishReport(Boolean.valueOf(true), itemId);
            return publishReport;
        }
        catch (PublicationException | WrongObjectFormatException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WrongObjectFormatException("Unable to read format ", e);
        }
        finally {
            if (this.isCustomToken()) {
                this.resetToken();
            }
        }
    }

    private String createProfile(String profileName, String xmlProfile) throws WrongObjectFormatException, PublicationException {
        Profile profile = null;
        try {
            profile = this.isForcedUrl() ? new Profile(this.getForcedUrl()) : new Profile();
            boolean exists = false;
            try {
                profile.read(profileName);
                exists = true;
            }
            catch (Throwable t) {
                exists = false;
            }
            switch (this.getOnClash()) {
                case SKIP: {
                    return null;
                }
                case FAIL: {
                    if (!exists) break;
                    throw new PublicationException("Profile " + profileName + " already existing");
                }
                case UPDATE: {
                    if (!exists) break;
                    return profile.update(profileName, xmlProfile);
                }
            }
            return profile.create(profileName, xmlProfile);
        }
        catch (WebApplicationException e) {
            GCatController.handleWebException(e);
            return null;
        }
        catch (MalformedURLException e) {
            throw new CatalogueInteractionException((Throwable)e);
        }
    }

    private String createResource(String itemId, String resourceName, String toCreate) throws WrongObjectFormatException, PublicationException {
        Resource resource = null;
        try {
            resource = this.isForcedUrl() ? new Resource(this.getForcedUrl()) : new Resource();
            try {
                log.debug("Trying to create resource {} for package {} ", (Object)resourceName, (Object)itemId);
                return resource.create(itemId, toCreate);
            }
            catch (WebApplicationException e) {
                if (e.getResponse().getStatus() == 409) {
                    switch (this.getOnClash()) {
                        case SKIP: {
                            return null;
                        }
                        case FAIL: {
                            throw new PublicationException("Resource " + resourceName + " already existing");
                        }
                        case UPDATE: {
                            log.debug("Looking for resource with name {} under item {} ", (Object)resourceName, (Object)itemId);
                            String resourceList = resource.list(itemId);
                            JsonNode listNode = mapper.readTree(resourceList);
                            Iterator iterator = listNode.elements();
                            String resourceId = null;
                            while (iterator.hasNext()) {
                                JsonNode res = (JsonNode)iterator.next();
                                if (!res.path("name").asText().equals(resourceName)) continue;
                                resourceId = res.path("id").asText();
                                break;
                            }
                            log.debug("Found id {} for resource Name {} ", resourceId, (Object)resourceName);
                            return resource.update(itemId, resourceId, toCreate);
                        }
                    }
                    return null;
                }
                throw e;
            }
        }
        catch (WebApplicationException e) {
            GCatController.handleWebException(e);
            return null;
        }
        catch (MalformedURLException e) {
            throw new CatalogueInteractionException((Throwable)e);
        }
        catch (IOException e) {
            throw new CatalogueInteractionException((Throwable)e);
        }
    }

    private String createItem(String toCreate, String name) throws WrongObjectFormatException, PublicationException {
        Item item = null;
        try {
            item = this.isForcedUrl() ? new Item(this.getForcedUrl()) : new Item();
            if (this.existsItem(item, name)) {
                return item.update(name, toCreate);
            }
            return item.create(toCreate, false);
        }
        catch (WebApplicationException e) {
            GCatController.handleWebException(e);
            return null;
        }
        catch (MalformedURLException e) {
            throw new CatalogueInteractionException((Throwable)e);
        }
    }

    private boolean existsItem(Item item, String name) {
        try {
            item.read(name);
            return true;
        }
        catch (WebApplicationException e) {
            log.debug("Read Item returned error. Assuming it's missing ", (Throwable)e);
            return false;
        }
    }

    private ControllerConfiguration.PublishingPolicy getOnClash() {
        return this.config.getOnClash();
    }

    private boolean isForcedUrl() {
        return this.desc.getCustomToken() == null && this.desc.getUrl() != null;
    }

    private URL getForcedUrl() throws MalformedURLException {
        return new URL(this.desc.getUrl());
    }

    private boolean isCustomToken() {
        return this.desc.getCustomToken() != null;
    }

    private void setCustomToken() {
        this.callerToken = SecurityTokenProvider.instance.get();
        SecurityTokenProvider.instance.set(this.desc.getCustomToken());
    }

    private void resetToken() {
        SecurityTokenProvider.instance.set(this.callerToken);
    }

    private void checkInstance() throws ControllerInstantiationFault {
        Item item = null;
        try {
            item = this.isForcedUrl() ? new Item(this.getForcedUrl()) : new Item();
            item.list(10, 0);
        }
        catch (Throwable t) {
            String msg = String.format("Unable to contact gCat with configuration %1$s ", this.desc);
            log.error(msg, t);
            throw new ControllerInstantiationFault(msg, t);
        }
    }

    private static String getProfileName(String xmlProfile) throws WrongObjectFormatException {
        try {
            Document doc = builder.parse(new ByteArrayInputStream(xmlProfile.getBytes()));
            return (String)expr.evaluate(doc, XPathConstants.STRING);
        }
        catch (Throwable t) {
            throw new WrongObjectFormatException("Unable to parse profile. ", t);
        }
    }

    private static String getId(String publishResponse) {
        try {
            return mapper.readTree(publishResponse).path("id").textValue();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("FAILED Parsing of " + publishResponse);
        }
    }

    private static String getPublishedUrl(String publishResponse) {
        try {
            Iterator iterator = mapper.readTree(publishResponse).path("extras").elements();
            while (iterator.hasNext()) {
                JsonNode node = (JsonNode)iterator.next();
                if (!node.path("key").asText().equals("Item URL")) continue;
                return node.path("value").asText();
            }
            return "N/A";
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("FAILED Parsing of " + publishResponse);
        }
    }

    private static void handleWebException(WebApplicationException e) throws WrongObjectFormatException, PublicationException {
        log.debug("Received Web Exception {} ", (Throwable)e);
        String msg = null;
        try {
            e.getResponse().readEntity(String.class);
        }
        catch (IllegalStateException e1) {
            msg = "Status : " + e.getResponse().getStatus();
        }
        switch (e.getResponse().getStatus()) {
            case 400: {
                throw new WrongObjectFormatException("BAD Request : " + msg, (Throwable)e);
            }
            case 401: {
                throw new CatalogueInteractionException("Unauthorized : " + msg, (Throwable)e);
            }
            case 404: {
                throw new CatalogueInteractionException("NOT FOUND : " + msg, (Throwable)e);
            }
            case 405: {
                throw new CatalogueInteractionException("Method Not Allowed : " + msg, (Throwable)e);
            }
            case 409: {
                throw new CatalogueInteractionException("Conflict : " + msg, (Throwable)e);
            }
            case 500: {
                throw new CatalogueInteractionException("Remote Error : " + msg, (Throwable)e);
            }
        }
        throw new PublicationException("Unexpected error code : " + msg, (Throwable)e);
    }

    static {
        xPathfactory = XPathFactory.newInstance();
        xpath = xPathfactory.newXPath();
        try {
            builder = factory.newDocumentBuilder();
            expr = xpath.compile("string(//metadataformat/@type)");
        }
        catch (ParserConfigurationException | XPathExpressionException e) {
            throw new RuntimeException("Unable to initialize Controller");
        }
    }
}

