/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.collectors.dm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.data.publishing.gCatFeeder.utils.ContextUtils;
import org.gcube.portlets.user.uriresolvermanager.UriResolverManager;
import org.gcube.portlets.user.uriresolvermanager.exception.IllegalArgumentException;
import org.gcube.portlets.user.uriresolvermanager.exception.UriResolverMapException;

public class URIResolver {
    private static final String CTLG_RESOLVER_NAME = "CTLG";
    private static final String ENTITY_CONTEXT = "entity_context";
    private static final String ENTITY_NAME = "entity_name";
    private static final String DATASET = "dataset";
    protected ObjectMapper mapper = new ObjectMapper();

    protected StringBuilder getStringBuilder(InputStream inputStream) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        return result;
    }

    public String getCatalogueItemURL(String name) throws UriResolverMapException, IllegalArgumentException {
        UriResolverManager resolver = new UriResolverManager(CTLG_RESOLVER_NAME);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(ENTITY_NAME, name);
        params.put(ENTITY_CONTEXT, DATASET);
        params.put("gcube_scope", ContextUtils.getCurrentScope());
        String shortLink = resolver.getLink(params, false);
        return shortLink;
    }
}

