/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.collectors.dm.model.ckan;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.DataMinerCollectorProperties;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.URIResolver;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.InternalAlgorithmDescriptor;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.UserIdentity;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.ckan.CKanExtraField;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.ckan.CkanItem;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.ckan.CkanResource;
import org.gcube.data.publishing.gCatFeeder.model.CatalogueFormatData;
import org.gcube.data.publishing.gCatFeeder.model.InternalConversionException;
import org.gcube.data.publishing.gCatFeeder.utils.ContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCatModel
implements CatalogueFormatData {
    private static final Logger log = LoggerFactory.getLogger(GCatModel.class);
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ISO_DATE;
    private static ObjectMapper mapper = new ObjectMapper();
    private static String profileXML = null;
    String profileID = DataMinerCollectorProperties.getProperty("ckan_resource_type");
    private String profile = profileXML;
    private CkanItem item = null;
    private ArrayList<CkanResource> resources = new ArrayList();

    public static void setStaticProfile(String toSet) {
        profileXML = toSet;
    }

    public static String getItemUrl(String name) {
        try {
            URIResolver uriResolver = new URIResolver();
            log.debug("Evaluating item url for {}", (Object)name);
            String catalogueItemURL = uriResolver.getCatalogueItemURL(name);
            log.info("Item URL for {} is {}", (Object)name, (Object)catalogueItemURL);
            return catalogueItemURL;
        }
        catch (Exception e) {
            log.warn("Unable to evaluate item URL for " + name, (Throwable)e);
            return null;
        }
    }

    public GCatModel(InternalAlgorithmDescriptor desc) {
        this.item = new CkanItem();
        this.item.setTitle(desc.getName() + " in " + ContextUtils.getCurrentScopeName());
        this.item.setLicense_id("CC-BY-NC-SA-4.0");
        this.item.setName(this.item.getTitle().toLowerCase().toLowerCase().replaceAll(" ", "_"));
        for (String tag : desc.getTags()) {
            this.item.getTags().add(new CkanItem.Tag(GCatModel.fixTag(tag)));
        }
        this.item.getTags().add(new CkanItem.Tag(ContextUtils.getCurrentScopeName()));
        this.item.getTags().add(new CkanItem.Tag("WPS"));
        this.item.getTags().add(new CkanItem.Tag("Analytics"));
        this.item.getExtras().add(new CKanExtraField("system:type", this.profileID));
        this.item.setPrivateFlag(desc.getPrivateFlag());
        this.item.getExtras().add(new CKanExtraField("Identity:Creator", desc.getAuthor().asStringValue()));
        this.item.getExtras().add(new CKanExtraField("Identity:CreationDate", dateFormatter.format(desc.getCreationDate())));
        this.item.getExtras().add(new CKanExtraField("AccessMode:UsageMode", "as-a-Service via Blue-Cloud Infrastructure"));
        this.item.getExtras().add(new CKanExtraField("AccessMode:Availability", "On-Line"));
        this.item.getExtras().add(new CKanExtraField("TechnicalDetails:Hosting Environment", "gCube SmartGear"));
        this.item.getExtras().add(new CKanExtraField("TechnicalDetails:Dependencies on Other SW", "gCube DataMiner"));
        this.item.getExtras().add(new CKanExtraField("Rights:Field/Scope of use", "Any use"));
        this.item.getExtras().add(new CKanExtraField("Rights:Basic rights", "Communication"));
        this.item.getExtras().add(new CKanExtraField("Rights:Basic rights", "Making available to the public"));
        this.item.getExtras().add(new CKanExtraField("Rights:Basic rights", "Distribution"));
        this.item.getExtras().add(new CKanExtraField("Attribution:Attribution requirements", String.format("Cite as: %1$s (%2$d): %3$s. %4$s. %5$s. %6$s. %7$s. Retrieved from the %8$s (%9$s) operated by D4Science.org www.d4science.org", desc.getAuthor().asStringValue(), LocalDateTime.now().getYear(), desc.getName(), desc.getVersion(), "Blue-Cloud", "DataMiner Process", GCatModel.getItemUrl(this.item.getName()), desc.getGatewayName(), desc.getGuiLink())));
        this.item.setNotes(desc.getDescription());
        if (desc.getGuiLink() != null) {
            try {
                URL url = new URL(desc.getGuiLink());
                this.resources.add(new CkanResource("Gateway Link", desc.getGuiLink(), url.getProtocol(), "Link to the GUI designed to operate with DataMiner"));
            }
            catch (Throwable t) {
                log.warn("Unable to generate resource from gui Link : " + desc.getGuiLink(), t);
            }
        }
        if (desc.getWpsLink() != null) {
            this.resources.add(new CkanResource("WPS Link", desc.getWpsLink(), "WPS", "WPS Link to the " + DataMinerCollectorProperties.getProperty("ckan_resource_type")));
        }
    }

    public String toCatalogueFormat() throws InternalConversionException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            mapper.writeValue((OutputStream)baos, (Object)this);
            return baos.toString();
        }
        catch (Throwable t) {
            throw new InternalConversionException("Unable to convert", t);
        }
    }

    static final String fixTag(String toFix) {
        String fixedTag = toFix.replaceAll(":", " ").replaceAll("[\\(\\)\\\\/]", "-").replaceAll("[\u2019']", "_");
        if (fixedTag.length() > 100) {
            fixedTag = fixedTag.substring(0, 96) + "...";
        }
        return fixedTag.trim();
    }

    static final String identityString(UserIdentity id) {
        StringBuilder builder = new StringBuilder(id.getLastName() + ", ");
        builder.append(id.getFirstName() + ", ");
        if (id.getEmail() != null) {
            builder.append(id.getEmail() + ", ");
        }
        if (id.getOrcid() != null) {
            builder.append(id.getOrcid() + ", ");
        }
        return builder.toString().substring(0, builder.lastIndexOf(","));
    }

    public GCatModel() {
    }

    public String getProfileID() {
        return this.profileID;
    }

    public String getProfile() {
        return this.profile;
    }

    public CkanItem getItem() {
        return this.item;
    }

    public ArrayList<CkanResource> getResources() {
        return this.resources;
    }

    public void setProfileID(String profileID) {
        this.profileID = profileID;
    }

    public void setItem(CkanItem item) {
        this.item = item;
    }

    public void setResources(ArrayList<CkanResource> resources) {
        this.resources = resources;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }
}

