/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.collectors.dm;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.analysis.dataminermanagercl.server.DataMinerService;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.data.analysis.dataminermanagercl.shared.process.OperatorCategory;
import org.gcube.data.analysis.dataminermanagercl.shared.process.OperatorsClassification;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.DataMinerCollectorProperties;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.InternalAlgorithmDescriptor;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.Parameter;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.UserIdentity;
import org.gcube.data.publishing.gCatFeeder.model.EnvironmentConfiguration;
import org.gcube.data.publishing.gCatFeeder.utils.ISUtils;
import org.gcube.data.publishing.gCatfeeder.collectors.DataCollector;
import org.gcube.data.publishing.gCatfeeder.collectors.model.faults.CollectorFault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMAlgorithmsInfoCollector
implements DataCollector<InternalAlgorithmDescriptor> {
    private static final Logger log = LoggerFactory.getLogger(DMAlgorithmsInfoCollector.class);
    private static final Pattern p = Pattern.compile("\\{Published by (.*)\\((.*(\\.)?.*\\)).*\\}$");
    private Map<String, String> env = null;

    public void setEnvironmentConfiguration(EnvironmentConfiguration envConfig) {
        if (envConfig != null) {
            log.debug("Current Environment Configuration is : " + envConfig.getCurrentConfiguration());
            this.env = envConfig.getCurrentConfiguration();
        } else {
            this.env = Collections.emptyMap();
            log.warn("NO ENVIRONMENT CONFIGURATION FOUND");
        }
    }

    public Set<InternalAlgorithmDescriptor> collect() throws CollectorFault {
        try {
            log.trace("Collecting information for Dataminer algorithms");
            HashSet<InternalAlgorithmDescriptor> toReturn = new HashSet<InternalAlgorithmDescriptor>();
            SClient client = new DataMinerService().getClient();
            String wpsbaseUrl = this.getWPSBasePath();
            List opClassifications = client.getOperatorsClassifications();
            log.debug("Found {} classifications.", (Object)opClassifications.size());
            for (OperatorsClassification opClass : opClassifications) {
                String opClassName = opClass.getName();
                List ops = opClass.getOperators();
                log.debug("Found {} operators under classification {} ", (Object)ops.size(), (Object)opClassName);
                for (Operator op : ops) {
                    String paramValue;
                    String paramType;
                    String paramName;
                    String paramDescription;
                    InternalAlgorithmDescriptor desc = new InternalAlgorithmDescriptor();
                    desc.setClassName(opClassName);
                    OperatorCategory cat = op.getCategory();
                    String categoryBriefDescription = cat.getBriefDescription();
                    String categoryDescription = cat.getDescription();
                    String categoryID = cat.getId();
                    String categoryName = cat.getName();
                    desc.setCategoryBriefDescription(categoryBriefDescription);
                    desc.setCategoryID(categoryID);
                    desc.setCategoryName(categoryName);
                    desc.setCategoryDescription(categoryDescription);
                    String opBriefDescription = op.getBriefDescription();
                    String opDescription = op.getDescription();
                    String opID = op.getId();
                    String operatorName = op.getName();
                    desc.setBriefDescription(opBriefDescription);
                    desc.setDescription(opDescription);
                    desc.setId(opID);
                    desc.setName(operatorName);
                    desc.setAuthor(DMAlgorithmsInfoCollector.parseUser(this.getAuthor(opDescription)));
                    desc.setMaintainer(DMAlgorithmsInfoCollector.parseUser(this.getAuthor(opDescription)));
                    for (org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter param : client.getInputParameters(op)) {
                        paramDescription = param.getDescription();
                        paramName = param.getName();
                        paramType = param.getTypology().toString();
                        paramValue = param.getValue();
                        desc.getInputParameters().add(new Parameter(paramName, paramType, paramDescription, paramValue));
                    }
                    for (org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter param : client.getOutputParameters(op)) {
                        paramDescription = param.getDescription();
                        paramName = param.getName();
                        paramType = param.getTypology().toString();
                        paramValue = param.getValue();
                        desc.getOutputParameters().add(new Parameter(paramName, paramType, paramDescription, paramValue));
                    }
                    desc.getTags().add(categoryName);
                    String guiBasePath = this.getGUIBasePath();
                    if (guiBasePath != null) {
                        desc.setGuiLink(this.getGUIBasePath() + "?" + DataMinerCollectorProperties.getProperty("gui_param_name") + "=" + opID);
                    }
                    if (wpsbaseUrl != null) {
                        desc.setWpsLink(wpsbaseUrl + "?Request=DescribeProcess&Version=1.0.0&Service=WPS&Identifier=" + opID);
                    }
                    desc.setPrivateFlag(Boolean.parseBoolean(this.env.get("DATAMINER_ALGORITHMS_COLLECTOR.PRIVATE")));
                    toReturn.add(desc);
                }
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new CollectorFault("Unable to retrieve information", (Throwable)e);
        }
    }

    private String getGUIBasePath() {
        return this.env.get("DATAMINER_ALGORITHMS_COLLECTOR.GUI_BASE_URL");
    }

    private String getAuthor(String algorithmDescription) {
        String toReturn = DMAlgorithmsInfoCollector.parseDescription(algorithmDescription);
        if (toReturn == null) {
            toReturn = this.env.get("DATAMINER_ALGORITHMS_COLLECTOR.DEFAULT_AUTHOR");
        }
        if (toReturn == null) {
            toReturn = DataMinerCollectorProperties.getProperty("default_author");
        }
        return toReturn;
    }

    private static final UserIdentity parseUser(String userString) {
        String splitter = null;
        if (userString.contains(" ")) {
            splitter = " ";
        } else if (userString.contains(".")) {
            splitter = "\\.";
        }
        String[] splitted = userString.split(splitter);
        return new UserIdentity(splitted[0], splitted[1], null, null);
    }

    private static final String parseDescription(String description) {
        Matcher m = p.matcher(description);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private final String getWPSBasePath() {
        try {
            ServiceEndpoint se = (ServiceEndpoint)ISUtils.queryForServiceEndpoints((String)"DataAnalysis", (String)"DataMiner").get(0);
            return ((ServiceEndpoint.AccessPoint)se.profile().accessPoints().iterator().next()).address();
        }
        catch (Throwable t) {
            log.warn("Unable to find DM proxy. No WPS URL will be provided", t);
            return null;
        }
    }
}

