/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.collectors.dm;

import java.io.InputStream;
import java.util.Collections;
import java.util.Scanner;
import java.util.Set;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.DMAlgorithmsInfoCollector;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.DataMinerCollectorProperties;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.GCATRetriever;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.GCATTransformer;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.InternalAlgorithmDescriptor;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.ckan.GCatModel;
import org.gcube.data.publishing.gCatFeeder.model.CatalogueFormatData;
import org.gcube.data.publishing.gCatFeeder.model.ControllerConfiguration;
import org.gcube.data.publishing.gCatFeeder.model.EnvironmentConfiguration;
import org.gcube.data.publishing.gCatfeeder.collectors.CatalogueRetriever;
import org.gcube.data.publishing.gCatfeeder.collectors.CollectorPlugin;
import org.gcube.data.publishing.gCatfeeder.collectors.DataCollector;
import org.gcube.data.publishing.gCatfeeder.collectors.DataTransformer;
import org.gcube.data.publishing.gCatfeeder.collectors.model.PluginDescriptor;
import org.gcube.data.publishing.gCatfeeder.collectors.model.faults.CatalogueNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMinerPlugin
implements CollectorPlugin<InternalAlgorithmDescriptor> {
    private static final Logger log = LoggerFactory.getLogger(DataMinerPlugin.class);
    private EnvironmentConfiguration env;

    public PluginDescriptor getDescriptor() {
        return new PluginDescriptor("DATAMINER_ALGORITHMS_COLLECTOR");
    }

    public CatalogueRetriever getRetrieverByCatalogueType(String catalogueType) throws CatalogueNotSupportedException {
        switch (catalogueType) {
            case "GCAT": {
                return GCATRetriever.get();
            }
        }
        throw new CatalogueNotSupportedException("No support for " + catalogueType);
    }

    public Set<String> getSupportedCatalogueTypes() {
        return Collections.singleton("GCAT");
    }

    public DataCollector<InternalAlgorithmDescriptor> getCollector() {
        DMAlgorithmsInfoCollector toReturn = new DMAlgorithmsInfoCollector();
        toReturn.setEnvironmentConfiguration(this.env);
        return toReturn;
    }

    public DataTransformer<? extends CatalogueFormatData, InternalAlgorithmDescriptor> getTransformerByCatalogueType(String catalogueType) throws CatalogueNotSupportedException {
        switch (catalogueType) {
            case "GCAT": {
                return new GCATTransformer();
            }
        }
        throw new CatalogueNotSupportedException("No support for " + catalogueType);
    }

    public void init() throws Exception {
        log.debug("Initializing..");
        InputStream is = this.getClass().getResourceAsStream("profile.xml");
        Scanner scanner = new Scanner(is).useDelimiter("\\A");
        String json = scanner.hasNext() ? scanner.next() : "";
        GCatModel.setStaticProfile(json);
        DataMinerCollectorProperties.init();
    }

    public void initInScope() throws Exception {
    }

    public ControllerConfiguration getPublisherControllerConfiguration(String catalogueType) throws CatalogueNotSupportedException {
        return new ControllerConfiguration();
    }

    public void setEnvironmentConfiguration(EnvironmentConfiguration env) {
        this.env = env;
    }
}

