/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.publishing.gCatFeeder.model.EnvironmentConfiguration;
import org.gcube.data.publishing.gCatFeeder.tests.BaseCollectorTest;
import org.gcube.data.publishing.gCatFeeder.utils.ISUtils;
import org.junit.BeforeClass;

public class InfrastructureTests {
    private static String testContext = null;
    private static EnvironmentConfiguration env;

    static {
        testContext = System.getProperty("testContext");
        System.out.println("TEST CONTEXT = " + testContext);
        env = new EnvironmentConfiguration(){

            public Map<String, String> getCurrentConfiguration() {
                if (InfrastructureTests.isTestInfrastructureEnabled()) {
                    return ISUtils.loadConfiguration();
                }
                return Collections.emptyMap();
            }
        };
    }

    protected static boolean isTestInfrastructureEnabled() {
        return testContext != null;
    }

    @BeforeClass
    public static void setTestContext() {
        if (InfrastructureTests.isTestInfrastructureEnabled()) {
            Properties props = new Properties();
            try {
                props.load(BaseCollectorTest.class.getResourceAsStream("/tokens.properties"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!props.containsKey(testContext)) {
                throw new RuntimeException("No token found for scope : " + testContext);
            }
            SecurityTokenProvider.instance.set(props.getProperty(testContext));
            ScopeProvider.instance.set(testContext);
        }
    }

    protected static EnvironmentConfiguration getEnvironmentConfiguration() {
        return env;
    }
}

