/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gFeed.collectors.oai;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;
import org.gcube.data.publishing.gCatFeeder.model.CatalogueFormatData;
import org.gcube.data.publishing.gCatFeeder.model.ControllerConfiguration;
import org.gcube.data.publishing.gCatFeeder.model.EnvironmentConfiguration;
import org.gcube.data.publishing.gCatFeeder.utils.Files;
import org.gcube.data.publishing.gCatfeeder.collectors.CatalogueRetriever;
import org.gcube.data.publishing.gCatfeeder.collectors.CollectorPlugin;
import org.gcube.data.publishing.gCatfeeder.collectors.DataCollector;
import org.gcube.data.publishing.gCatfeeder.collectors.DataTransformer;
import org.gcube.data.publishing.gCatfeeder.collectors.model.PluginDescriptor;
import org.gcube.data.publishing.gCatfeeder.collectors.model.faults.CatalogueNotSupportedException;
import org.gcube.data.publishing.gFeed.collectors.oai.Constants;
import org.gcube.data.publishing.gFeed.collectors.oai.GCATRetriever;
import org.gcube.data.publishing.gFeed.collectors.oai.OAICollector;
import org.gcube.data.publishing.gFeed.collectors.oai.model.OAIRecord;
import org.gcube.data.publishing.gFeed.collectors.oai.model.ckan.GCatTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAIHarvester
implements CollectorPlugin<OAIRecord> {
    private static final Logger log = LoggerFactory.getLogger(OAIHarvester.class);

    public PluginDescriptor getDescriptor() {
        return new PluginDescriptor("OAI_COLLECTOR");
    }

    public CatalogueRetriever getRetrieverByCatalogueType(String catalogueType) throws CatalogueNotSupportedException {
        switch (catalogueType) {
            case "GCAT": {
                return GCATRetriever.get();
            }
        }
        throw new CatalogueNotSupportedException("No support for " + catalogueType);
    }

    public Set<String> getSupportedCatalogueTypes() {
        return Collections.singleton("GCAT");
    }

    public DataTransformer<? extends CatalogueFormatData, OAIRecord> getTransformerByCatalogueType(String catalogueType) throws CatalogueNotSupportedException {
        switch (catalogueType) {
            case "GCAT": {
                return new GCatTransformer();
            }
        }
        throw new CatalogueNotSupportedException("No support for " + catalogueType);
    }

    public DataCollector<OAIRecord> getCollector() {
        return new OAICollector();
    }

    public ControllerConfiguration getPublisherControllerConfiguration(String catalogueType) throws CatalogueNotSupportedException {
        return new ControllerConfiguration();
    }

    public void init() throws Exception {
        String harvestedObjectProfile = Files.readFileAsString((File)Files.getFileFromResources((String)"profiles/HarvestedObject.xml"), (Charset)Charset.defaultCharset());
        Constants.xmlProfiles.put("HarvestedObject", harvestedObjectProfile);
        log.debug("Loaded profiles " + Constants.xmlProfiles.keySet());
    }

    public void initInScope() throws Exception {
    }

    public void setEnvironmentConfiguration(EnvironmentConfiguration env) {
    }
}

