package org.gcube.data.publishing.gCatFeeder.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;

public class Files {

	public static File getFileFromResources(String fileName) {

        ClassLoader classLoader =Files.class.getClassLoader();

        URL resource = classLoader.getResource(fileName);
        if (resource == null) {
            throw new IllegalArgumentException("file is not found!");
        } else {
            return new File(resource.getFile());
        }

    }	

	public static String readFileAsString(File toRead, Charset encoding) 
			  throws IOException{
	
		FileInputStream fis = new FileInputStream(toRead);
		byte[] buffer = new byte[10];
		StringBuilder sb = new StringBuilder();
		while (fis.read(buffer) != -1) {
			sb.append(new String(buffer));
			buffer = new byte[10];
		}
		fis.close();

		return sb.toString();
		
	}
	

//	public static String readFileAsString(String path, Charset encoding) 
//			  throws IOException 
//	{
//	  byte[] encoded = java.nio.file.Files.readAllBytes(Paths.get(path));
//	  return new String(encoded, encoding);
//	}
//	
	
	public static String getName(String path) {
		
		return path.substring((path.contains(File.separator)?path.lastIndexOf(File.separator)+1:0)
				,(path.contains(".")?path.lastIndexOf("."):path.length()));
		
	}
}
