/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.publishing.gCatFeeder.collectors.dm.model.ckan;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.DataMinerCollectorProperties;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.InternalAlgorithmDescriptor;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.Parameter;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.UserIdentity;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.ckan.CKanExtraField;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.ckan.CkanItem;
import org.gcube.data.publishing.gCatFeeder.collectors.dm.model.ckan.CkanResource;
import org.gcube.data.publishing.gCatFeeder.model.CatalogueFormatData;
import org.gcube.data.publishing.gCatFeeder.model.InternalConversionException;
import org.gcube.data.publishing.gCatFeeder.utils.ContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCatModel
implements CatalogueFormatData {
    private static final Logger log = LoggerFactory.getLogger(GCatModel.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private static String profileXML = null;
    String profileID = DataMinerCollectorProperties.getProperty("ckan_resource_type");
    private String profile = profileXML;
    private CkanItem item = null;
    private ArrayList<CkanResource> resources = new ArrayList();

    public static void setStaticProfile(String toSet) {
        profileXML = toSet;
    }

    public GCatModel(InternalAlgorithmDescriptor desc) {
        this.item = new CkanItem();
        this.item.setTitle(desc.getName() + " in " + ContextUtils.getCurrentScopeName());
        this.item.setLicense_id("CC-BY-NC-SA-4.0");
        this.item.setName(this.item.getTitle().toLowerCase().toLowerCase().replaceAll(" ", "_"));
        for (String tag : desc.getTags()) {
            this.item.getTags().add(new CkanItem.Tag(GCatModel.fixTag(tag)));
        }
        this.item.getTags().add(new CkanItem.Tag(ContextUtils.getCurrentScopeName()));
        this.item.getTags().add(new CkanItem.Tag("WPS"));
        this.item.getTags().add(new CkanItem.Tag("Analytics"));
        this.item.getExtras().add(new CKanExtraField("system:type", this.profileID));
        this.item.setPrivateFlag(desc.getPrivateFlag());
        for (Parameter param : desc.getInputParameters()) {
            this.item.getExtras().add(new CKanExtraField(this.profileID + ":Input Parameter", String.format("%1$s [%2$s] %3$s : %4$s", param.getName(), param.getType(), param.getValue() != null && !param.getValue().isEmpty() ? "default : " + param.getValue() : "", param.getDescription())));
        }
        for (Parameter param : desc.getOutputParameters()) {
            this.item.getExtras().add(new CKanExtraField(this.profileID + ":Output Parameter", String.format("%1$s [%2$s] %3$s : %4$s", param.getName(), param.getType(), param.getValue() != null && !param.getValue().isEmpty() ? "default : " + param.getValue() : "", param.getDescription())));
        }
        this.item.setNotes(desc.getDescription());
        this.item.getExtras().add(new CKanExtraField(this.profileID + ":Process Author", desc.getAuthor().asStringValue()));
        this.item.getExtras().add(new CKanExtraField(this.profileID + ":Process Maintainer", desc.getAuthor().asStringValue()));
        if (desc.getGuiLink() != null) {
            try {
                URL url = new URL(desc.getGuiLink());
                this.resources.add(new CkanResource("Gateway Link", desc.getGuiLink(), url.getProtocol(), "Link to the GUI designed to operate with DataMiner"));
            }
            catch (Throwable t) {
                log.warn("Unable to generate resource from gui Link : " + desc.getGuiLink(), t);
            }
        }
        if (desc.getWpsLink() != null) {
            this.resources.add(new CkanResource("WPS Link", desc.getWpsLink(), "WPS", "WPS Link to the " + DataMinerCollectorProperties.getProperty("ckan_resource_type")));
        }
    }

    public String toCatalogueFormat() throws InternalConversionException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            mapper.writeValue((OutputStream)baos, (Object)this);
            return baos.toString();
        }
        catch (Throwable t) {
            throw new InternalConversionException("Unable to convert", t);
        }
    }

    static final String fixTag(String toFix) {
        String fixedTag = toFix.replaceAll(":", " ").replaceAll("[\\(\\)\\\\/]", "-").replaceAll("[\u2019']", "_");
        if (fixedTag.length() > 100) {
            fixedTag = fixedTag.substring(0, 96) + "...";
        }
        return fixedTag.trim();
    }

    static final String identityString(UserIdentity id) {
        StringBuilder builder = new StringBuilder(id.getLastName() + ", ");
        builder.append(id.getFirstName() + ", ");
        if (id.getEmail() != null) {
            builder.append(id.getEmail() + ", ");
        }
        if (id.getOrcid() != null) {
            builder.append(id.getOrcid() + ", ");
        }
        return builder.toString().substring(0, builder.lastIndexOf(","));
    }

    public GCatModel() {
    }

    public String getProfileID() {
        return this.profileID;
    }

    public String getProfile() {
        return this.profile;
    }

    public CkanItem getItem() {
        return this.item;
    }

    public ArrayList<CkanResource> getResources() {
        return this.resources;
    }

    public void setProfileID(String profileID) {
        this.profileID = profileID;
    }

    public void setItem(CkanItem item) {
        this.item = item;
    }

    public void setResources(ArrayList<CkanResource> resources) {
        this.resources = resources;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }
}

