/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.wps.repository;

import com.google.common.base.Predicate;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.gcube.data.analysis.wps.repository.AlgorithmUpdater;
import org.n52.wps.algorithm.annotation.Algorithm;
import org.n52.wps.server.IAlgorithm;
import org.n52.wps.server.IAlgorithmRepository;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GcubeAlgorithmRepository
implements IAlgorithmRepository {
    private static Logger log = LoggerFactory.getLogger(GcubeAlgorithmRepository.class);
    private static AlgorithmUpdater updater = null;
    private static Reflections reflection;
    private static final String PACKAGE_TO_FIND = "org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses";

    public GcubeAlgorithmRepository() {
        log.info("gcube algorithm repository started");
        if (updater == null) {
            throw new RuntimeException("GcubeAlgorithmRepository cannot be initialized: updater is null");
        }
        updater.init();
        Thread.currentThread().setContextClassLoader(updater.getLoader());
        GcubeAlgorithmRepository.updateRepository();
        updater.startWhatcher();
    }

    public ProcessDescriptionType getProcessDescription(String identifier) {
        Thread.currentThread().setContextClassLoader(updater.getLoader());
        GcubeAlgorithmRepository.updateRepository();
        log.info("getProcessDescription with identifier {} ", (Object)identifier);
        try {
            Set classes = reflection.getTypesAnnotatedWith(Algorithm.class);
            for (Class _class : classes) {
                if (!_class.getAnnotation(Algorithm.class).identifier().equals(identifier)) continue;
                return ((IAlgorithm)_class.newInstance()).getDescription();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException(String.format("Algorithm with process id %s not found", identifier));
    }

    public boolean containsAlgorithm(String identifier) {
        Thread.currentThread().setContextClassLoader(updater.getLoader());
        GcubeAlgorithmRepository.updateRepository();
        log.info("containsAlgorithm with identifier {} ", (Object)identifier);
        Set classes = reflection.getTypesAnnotatedWith(Algorithm.class);
        for (Class _class : classes) {
            if (!_class.getAnnotation(Algorithm.class).identifier().equals(identifier)) continue;
            return true;
        }
        return false;
    }

    public IAlgorithm getAlgorithm(String identifier) {
        Thread.currentThread().setContextClassLoader(updater.getLoader());
        GcubeAlgorithmRepository.updateRepository();
        log.info("getAlgorithm with identifier {} ", (Object)identifier);
        try {
            Set classes = reflection.getTypesAnnotatedWith(Algorithm.class);
            for (Class _class : classes) {
                if (!_class.getAnnotation(Algorithm.class).identifier().equals(identifier)) continue;
                if (IAlgorithm.class.isAssignableFrom(_class)) {
                    return (IAlgorithm)_class.newInstance();
                }
                log.warn("found algorothm class {} is no assignable from {}", (Object)_class.getName(), (Object)IAlgorithm.class.getName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException(String.format("Algorithm with id %s not found", identifier));
    }

    public static Set<Class<?>> getAllAlgorithms() {
        Thread.currentThread().setContextClassLoader(updater.getLoader());
        GcubeAlgorithmRepository.updateRepository();
        return reflection.getTypesAnnotatedWith(Algorithm.class);
    }

    private static synchronized void updateRepository() {
        if (reflection == null || updater.mustUpdate()) {
            log.info("updating repository ({}) ", (Object)updater.mustUpdate());
            updater.reset();
            ConfigurationBuilder confBuilder = new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder().include(FilterBuilder.prefix((String)"org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses"))).setUrls(((URLClassLoader)updater.getLoader()).getURLs());
            reflection = new Reflections((Configuration)confBuilder);
        }
    }

    public Collection<String> getAlgorithmNames() {
        Thread.currentThread().setContextClassLoader(updater.getLoader());
        GcubeAlgorithmRepository.updateRepository();
        ArrayList<String> toReturn = new ArrayList<String>();
        Set classes = reflection.getTypesAnnotatedWith(Algorithm.class);
        for (Class _class : classes) {
            toReturn.add(_class.getAnnotation(Algorithm.class).title());
        }
        return toReturn;
    }

    public void shutdown() {
        reflection = null;
    }

    public static boolean setUpdater(AlgorithmUpdater au) {
        if (updater == null) {
            updater = au;
            return true;
        }
        return false;
    }

    public static AlgorithmUpdater getUpdater() {
        return updater;
    }
}

