/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.wps.repository;

import org.gcube.data.analysis.wps.repository.AlgorithmUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AlgorithmUpdater {
    private static final Logger log = LoggerFactory.getLogger(AlgorithmUpdater.class);
    private String algorithmDirectory;
    private boolean mustUpdate = false;
    private WatcherThread watcherThread = null;

    public AlgorithmUpdater(String algorithmDirectory) {
        this.algorithmDirectory = algorithmDirectory;
    }

    protected synchronized boolean mustUpdate() {
        return this.mustUpdate;
    }

    protected synchronized void reset() {
        this.mustUpdate = false;
    }

    public boolean isStarted() {
        return this.watcherThread != null;
    }

    protected void init() {
        this.watcherThread = new WatcherThread(this, Thread.currentThread().getContextClassLoader(), this.algorithmDirectory);
    }

    protected void startWhatcher() {
        this.watcherThread.start();
    }

    public ClassLoader getLoader() {
        return this.watcherThread.getLoader();
    }

    protected void shutdown() {
        if (this.isStarted()) {
            this.watcherThread = null;
        }
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }

    static /* synthetic */ void access$1(AlgorithmUpdater algorithmUpdater, boolean bl) {
        algorithmUpdater.mustUpdate = bl;
    }
}

