/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.wps;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.wps.repository.GcubeAlgorithmRepository;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure.InfrastructureDialoguer;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.ConfigurationManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.TokenManager;
import org.n52.wps.algorithm.annotation.Algorithm;
import org.n52.wps.commons.WPSConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCapabilitiesBuilder {
    public static String processString = "<wps:Process wps:processVersion=\"1.1.0\">\n\t<ows:Identifier>#CLASS#</ows:Identifier>\n\t<ows:Title>#TITLE#</ows:Title>\n</wps:Process>";
    private static final Logger LOGGER = LoggerFactory.getLogger(GetCapabilitiesBuilder.class);

    public String getClassification(String algorithmName, ConfigurationManager configManager) throws Exception {
        LOGGER.debug("Searching for a classification of " + algorithmName);
        HashMap algorithmsClassification = ProcessorsFactory.getAllFeaturesUser((AlgorithmConfiguration)configManager.getConfig());
        String rightClassification = "Others";
        for (String classification : algorithmsClassification.keySet()) {
            List algorithms = (List)algorithmsClassification.get(classification);
            if (!algorithms.contains(algorithmName)) continue;
            LOGGER.debug("Found classification" + classification);
            return classification;
        }
        LOGGER.debug("No classification found for " + algorithmName);
        return rightClassification;
    }

    public String buildGetCapabilities(Map<String, String[]> parameters) throws Exception {
        LinkedHashMap<String, String> basicInputs = new LinkedHashMap<String, String>();
        ConfigurationManager configManager = new ConfigurationManager();
        TokenManager tokenm = new TokenManager();
        tokenm.getCredentials();
        String scope = tokenm.getScope();
        String username = tokenm.getUserName();
        String token = tokenm.getToken();
        basicInputs.put(ConfigurationManager.scopeParameter, scope);
        basicInputs.put(ConfigurationManager.usernameParameter, username);
        basicInputs.put(ConfigurationManager.tokenParameter, token);
        configManager.configAlgorithmEnvironment(basicInputs);
        LOGGER.debug("Initializing Capabilities Skeleton in scope " + configManager.getScope() + " with user " + configManager.getUsername());
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("templates/wpsCapabilitiesSkeleton.xml");
        String stringTemplate = IOUtils.toString((InputStream)is, (String)"UTF-8");
        String host = WPSConfig.getInstance().getWPSConfig().getServer().getHostname();
        String port = WPSConfig.getInstance().getWPSConfig().getServer().getHostport();
        stringTemplate = stringTemplate.replace("#HOST#", host).replace("#PORT#", port);
        LOGGER.debug("Host: " + host + " Port: " + port);
        LinkedHashMap<String, String> allalgorithms = new LinkedHashMap<String, String>();
        LOGGER.info("using classloader class {} ", (Object)Thread.currentThread().getContextClassLoader().getClass().getSimpleName());
        Set algorithmsClass = GcubeAlgorithmRepository.getAllAlgorithms();
        LOGGER.info("class found with annotation Algorithm are {}", (Object)algorithmsClass.size());
        for (Class classfind : algorithmsClass) {
            Algorithm algorithmInfo = classfind.getAnnotation(Algorithm.class);
            if (algorithmInfo == null) continue;
            LOGGER.debug("Retrieving local declared Algorithm: " + algorithmInfo.title());
            allalgorithms.put(algorithmInfo.title(), classfind.getName());
        }
        LOGGER.debug("Getting algorithms from the infrastructure");
        InfrastructureDialoguer dialoguer = new InfrastructureDialoguer(configManager.getScope());
        List algorithmsInScope = dialoguer.getAlgorithmsInScope();
        LOGGER.debug("Found {}  algorithms in scope {} ", (Object)algorithmsInScope.size(), (Object)ScopeProvider.instance.get());
        StringBuffer capabilities = new StringBuffer();
        HashSet algorithmsSet = new HashSet(algorithmsInScope);
        for (String algorithmInScope : algorithmsSet) {
            String classAlgorithm = (String)allalgorithms.get(algorithmInScope);
            if (classAlgorithm == null) continue;
            LOGGER.debug("Approving " + classAlgorithm + " to capabilities ");
            String algorithmTitle = this.getClassification(algorithmInScope, configManager) + ":" + algorithmInScope;
            capabilities.append(processString.replace("#TITLE#", algorithmTitle).replace("#CLASS#", classAlgorithm));
        }
        stringTemplate = stringTemplate.replace("#PROCESSES#", capabilities.toString());
        LOGGER.debug("Get capabilities built");
        return stringTemplate;
    }
}

