/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.security.Provider;
import java.security.Security;
import java.util.concurrent.atomic.AtomicReference;
import org.gcube.io.jsonwebtoken.lang.Classes;

final class Providers {
    private static final String BC_PROVIDER_CLASS_NAME = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    static final boolean BOUNCY_CASTLE_AVAILABLE = Classes.isAvailable("org.bouncycastle.jce.provider.BouncyCastleProvider");
    private static final AtomicReference<Provider> BC_PROVIDER = new AtomicReference();

    private Providers() {
    }

    public static Provider findBouncyCastle() {
        if (!BOUNCY_CASTLE_AVAILABLE) {
            return null;
        }
        Provider provider = BC_PROVIDER.get();
        if (provider == null) {
            Provider[] providers;
            Class clazz = Classes.forName(BC_PROVIDER_CLASS_NAME);
            for (Provider aProvider : providers = Security.getProviders()) {
                if (!clazz.isInstance(aProvider)) continue;
                BC_PROVIDER.set(aProvider);
                return aProvider;
            }
            provider = (Provider)Classes.newInstance(clazz);
            BC_PROVIDER.set(provider);
        }
        return provider;
    }
}

