/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.gcube.io.jsonwebtoken.impl.io.Streams;
import org.gcube.io.jsonwebtoken.impl.io.TeeOutputStream;
import org.gcube.io.jsonwebtoken.impl.lang.Bytes;
import org.gcube.io.jsonwebtoken.impl.lang.CheckedFunction;
import org.gcube.io.jsonwebtoken.impl.security.AesAlgorithm;
import org.gcube.io.jsonwebtoken.impl.security.DefaultMacAlgorithm;
import org.gcube.io.jsonwebtoken.impl.security.DefaultSecureRequest;
import org.gcube.io.jsonwebtoken.impl.security.RandomSecretKeyBuilder;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.security.AeadAlgorithm;
import org.gcube.io.jsonwebtoken.security.AeadRequest;
import org.gcube.io.jsonwebtoken.security.AeadResult;
import org.gcube.io.jsonwebtoken.security.DecryptAeadRequest;
import org.gcube.io.jsonwebtoken.security.SecretKeyBuilder;
import org.gcube.io.jsonwebtoken.security.SecureRequest;
import org.gcube.io.jsonwebtoken.security.SignatureException;

public class HmacAesAeadAlgorithm
extends AesAlgorithm
implements AeadAlgorithm {
    private static final String TRANSFORMATION_STRING = "AES/CBC/PKCS5Padding";
    private final DefaultMacAlgorithm SIGALG;

    private static int digestLength(int keyLength) {
        return keyLength * 2;
    }

    private static String id(int keyLength) {
        return "A" + keyLength + "CBC-HS" + HmacAesAeadAlgorithm.digestLength(keyLength);
    }

    public HmacAesAeadAlgorithm(String id, DefaultMacAlgorithm sigAlg) {
        super(id, TRANSFORMATION_STRING, sigAlg.getKeyBitLength());
        this.SIGALG = sigAlg;
    }

    public HmacAesAeadAlgorithm(int keyBitLength) {
        this(HmacAesAeadAlgorithm.id(keyBitLength), new DefaultMacAlgorithm(HmacAesAeadAlgorithm.id(keyBitLength), "HmacSHA" + HmacAesAeadAlgorithm.digestLength(keyBitLength), keyBitLength));
    }

    @Override
    public int getKeyBitLength() {
        return super.getKeyBitLength() * 2;
    }

    @Override
    public SecretKeyBuilder key() {
        return new RandomSecretKeyBuilder("AES", this.getKeyBitLength());
    }

    byte[] assertKeyBytes(SecureRequest<?, SecretKey> request) {
        SecretKey key = (SecretKey)Assert.notNull(request.getKey(), "Request key cannot be null.");
        return this.validateLength(key, this.keyBitLength * 2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encrypt(AeadRequest req, AeadResult res) {
        SecretKeySpec encryptionKey;
        Assert.notNull(req, "Request cannot be null.");
        Assert.notNull(res, "Result cannot be null.");
        byte[] compositeKeyBytes = this.assertKeyBytes(req);
        int halfCount = compositeKeyBytes.length / 2;
        byte[] macKeyBytes = Arrays.copyOfRange(compositeKeyBytes, 0, halfCount);
        byte[] encKeyBytes = Arrays.copyOfRange(compositeKeyBytes, halfCount, compositeKeyBytes.length);
        try {
            encryptionKey = new SecretKeySpec(encKeyBytes, "AES");
        }
        finally {
            Bytes.clear(encKeyBytes);
            Bytes.clear(compositeKeyBytes);
        }
        final InputStream plaintext = (InputStream)Assert.notNull(req.getPayload(), "Request content (plaintext) InputStream cannot be null.");
        OutputStream out = Assert.notNull(res.getOutputStream(), "Result ciphertext OutputStream cannot be null.");
        InputStream aad = req.getAssociatedData();
        byte[] iv = this.ensureInitializationVector(req);
        final AlgorithmParameterSpec ivSpec = this.getIvSpec(iv);
        ByteArrayOutputStream copy = new ByteArrayOutputStream(8192);
        final TeeOutputStream tee = new TeeOutputStream(out, copy);
        this.jca(req).withCipher(new CheckedFunction<Cipher, Object>(){

            @Override
            public Object apply(Cipher cipher) throws Exception {
                cipher.init(1, (Key)encryptionKey, ivSpec);
                HmacAesAeadAlgorithm.this.withCipher(cipher, plaintext, tee);
                return null;
            }
        });
        byte[] aadBytes = aad == null ? Bytes.EMPTY : Streams.bytes(aad, "Unable to read AAD bytes.");
        try {
            byte[] tag = this.sign(aadBytes, iv, Streams.of(copy.toByteArray()), macKeyBytes);
            res.setTag(tag).setIv(iv);
        }
        finally {
            Bytes.clear(macKeyBytes);
        }
    }

    private byte[] sign(byte[] aad, byte[] iv, InputStream ciphertext, byte[] macKeyBytes) {
        long aadLength = org.gcube.io.jsonwebtoken.lang.Arrays.length(aad);
        long aadLengthInBits = aadLength * 8L;
        long aadLengthInBitsAsUnsignedInt = aadLengthInBits & 0xFFFFFFFFL;
        byte[] AL = Bytes.toBytes(aadLengthInBitsAsUnsignedInt);
        ArrayList<InputStream> streams = new ArrayList<InputStream>(4);
        if (!Bytes.isEmpty(aad)) {
            streams.add(Streams.of(aad));
        }
        streams.add(Streams.of(iv));
        streams.add(ciphertext);
        streams.add(Streams.of(AL));
        SequenceInputStream in = new SequenceInputStream(Collections.enumeration(streams));
        SecretKeySpec key = new SecretKeySpec(macKeyBytes, this.SIGALG.getJcaName());
        DefaultSecureRequest<SequenceInputStream, SecretKeySpec> request = new DefaultSecureRequest<SequenceInputStream, SecretKeySpec>(in, null, null, key);
        byte[] digest = this.SIGALG.digest(request);
        return this.assertTag(Arrays.copyOfRange(digest, 0, macKeyBytes.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrypt(DecryptAeadRequest req, final OutputStream plaintext) {
        byte[] digest;
        SecretKeySpec decryptionKey;
        Assert.notNull(req, "Request cannot be null.");
        Assert.notNull(plaintext, "Plaintext OutputStream cannot be null.");
        byte[] compositeKeyBytes = this.assertKeyBytes(req);
        int halfCount = compositeKeyBytes.length / 2;
        byte[] macKeyBytes = Arrays.copyOfRange(compositeKeyBytes, 0, halfCount);
        byte[] encKeyBytes = Arrays.copyOfRange(compositeKeyBytes, halfCount, compositeKeyBytes.length);
        try {
            decryptionKey = new SecretKeySpec(encKeyBytes, "AES");
        }
        finally {
            Bytes.clear(encKeyBytes);
            Bytes.clear(compositeKeyBytes);
        }
        InputStream in = (InputStream)Assert.notNull(req.getPayload(), "Decryption request content (ciphertext) InputStream cannot be null.");
        InputStream aad = req.getAssociatedData();
        byte[] tag = this.assertTag(req.getDigest());
        byte[] iv = this.assertDecryptionIv(req);
        final AlgorithmParameterSpec ivSpec = this.getIvSpec(iv);
        byte[] aadBytes = aad == null ? Bytes.EMPTY : Streams.bytes(aad, "Unable to read AAD bytes.");
        try {
            digest = this.sign(aadBytes, iv, in, macKeyBytes);
        }
        finally {
            Bytes.clear(macKeyBytes);
        }
        if (!MessageDigest.isEqual(digest, tag)) {
            String msg = "Ciphertext decryption failed: Authentication tag verification failed.";
            throw new SignatureException(msg);
        }
        Streams.reset(in);
        final InputStream ciphertext = in;
        this.jca(req).withCipher(new CheckedFunction<Cipher, byte[]>(){

            @Override
            public byte[] apply(Cipher cipher) throws Exception {
                cipher.init(2, (Key)decryptionKey, ivSpec);
                HmacAesAeadAlgorithm.this.withCipher(cipher, ciphertext, plaintext);
                return Bytes.EMPTY;
            }
        });
    }
}

