/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gcube.io.jsonwebtoken.impl.ParameterMap;
import org.gcube.io.jsonwebtoken.impl.lang.Converter;
import org.gcube.io.jsonwebtoken.impl.lang.Parameter;
import org.gcube.io.jsonwebtoken.impl.lang.Parameters;
import org.gcube.io.jsonwebtoken.impl.security.JwkConverter;
import org.gcube.io.jsonwebtoken.lang.Collections;
import org.gcube.io.jsonwebtoken.security.Jwk;
import org.gcube.io.jsonwebtoken.security.JwkSet;

public class DefaultJwkSet
extends ParameterMap
implements JwkSet {
    private static final String NAME = "JWK Set";
    static final Parameter<Set<Jwk<?>>> KEYS = DefaultJwkSet.param(JwkConverter.ANY);

    static Parameter<Set<Jwk<?>>> param(Converter<Jwk<?>, ?> converter) {
        return (Parameter)Parameters.builder(JwkConverter.JWK_CLASS).setConverter(converter).set().setId("keys").setName("JSON Web Keys").setSecret(true).build();
    }

    public DefaultJwkSet(Parameter<Set<Jwk<?>>> param, Map<String, ?> src) {
        super(Parameters.registry(param), src);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Set<Jwk<?>> getKeys() {
        Set<Jwk<?>> jwks = this.get(KEYS);
        if (Collections.isEmpty(jwks)) {
            return Collections.emptySet();
        }
        return Collections.immutable(jwks);
    }

    @Override
    public Iterator<Jwk<?>> iterator() {
        return this.getKeys().iterator();
    }
}

