/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import org.gcube.io.jsonwebtoken.JweHeader;
import org.gcube.io.jsonwebtoken.impl.security.DefaultKeyRequest;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.security.AeadAlgorithm;
import org.gcube.io.jsonwebtoken.security.DecryptionKeyRequest;

public class DefaultDecryptionKeyRequest<K extends Key>
extends DefaultKeyRequest<byte[]>
implements DecryptionKeyRequest<K> {
    private final K decryptionKey;

    public DefaultDecryptionKeyRequest(byte[] encryptedCek, Provider provider, SecureRandom secureRandom, JweHeader header, AeadAlgorithm encryptionAlgorithm, K decryptionKey) {
        super(encryptedCek, provider, secureRandom, header, encryptionAlgorithm);
        this.decryptionKey = (Key)Assert.notNull(decryptionKey, "decryption key cannot be null.");
    }

    @Override
    protected void assertBytePayload(byte[] payload) {
        Assert.notNull(payload, "encrypted key bytes cannot be null (but may be empty.");
    }

    @Override
    public K getKey() {
        return this.decryptionKey;
    }
}

