/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gcube.io.jsonwebtoken.impl.lang.Converter;
import org.gcube.io.jsonwebtoken.impl.lang.Function;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Collections;

class CollectionConverter<T, C extends Collection<T>>
implements Converter<C, Object> {
    private final Converter<T, Object> elementConverter;
    private final Function<Integer, C> fn;

    public static <T> CollectionConverter<T, List<T>> forList(Converter<T, Object> elementConverter) {
        return new CollectionConverter(elementConverter, new CreateListFunction());
    }

    public static <T> CollectionConverter<T, Set<T>> forSet(Converter<T, Object> elementConverter) {
        return new CollectionConverter(elementConverter, new CreateSetFunction());
    }

    public CollectionConverter(Converter<T, Object> elementConverter, Function<Integer, C> fn) {
        this.elementConverter = Assert.notNull(elementConverter, "Element converter cannot be null.");
        this.fn = Assert.notNull(fn, "Collection function cannot be null.");
    }

    @Override
    public Object applyTo(C ts) {
        if (Collections.isEmpty(ts)) {
            return ts;
        }
        Collection c = (Collection)this.fn.apply(ts.size());
        for (Object element : ts) {
            Object encoded = this.elementConverter.applyTo(element);
            c.add(encoded);
        }
        return c;
    }

    private C toElementList(Collection<?> c) {
        Assert.notEmpty(c, "Collection cannot be null or empty.");
        Collection result = (Collection)this.fn.apply(c.size());
        for (Object o : c) {
            T element = this.elementConverter.applyFrom(o);
            result.add(element);
        }
        return (C)result;
    }

    @Override
    public C applyFrom(Object value) {
        if (value == null) {
            return null;
        }
        List c = value.getClass().isArray() && !value.getClass().getComponentType().isPrimitive() ? Collections.arrayToList(value) : (value instanceof Collection ? (List)value : java.util.Collections.singletonList(value));
        Object result = Collections.isEmpty(c) ? (Collection)this.fn.apply(0) : this.toElementList(c);
        return result;
    }

    private static class CreateSetFunction<T>
    implements Function<Integer, Set<T>> {
        private CreateSetFunction() {
        }

        @Override
        public Set<T> apply(Integer size) {
            return size > 0 ? new LinkedHashSet(size) : new LinkedHashSet();
        }
    }

    private static class CreateListFunction<A>
    implements Function<Integer, List<A>> {
        private CreateListFunction() {
        }

        @Override
        public List<A> apply(Integer size) {
            return size > 0 ? new ArrayList(size) : new ArrayList();
        }
    }
}

