/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxrest.request;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Objects;
import org.gcube.common.gxhttp.reference.GXConnection;
import org.gcube.common.gxhttp.reference.GXHTTP;
import org.gcube.common.gxhttp.reference.GXHTTPRequestBuilder;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GXHTTPStreamRequest
implements GXHTTP<InputStream, GXInboundResponse> {
    protected static final Logger logger = LoggerFactory.getLogger(GXHTTPStreamRequest.class);
    GXHTTPRequestBuilder builder = new GXHTTPRequestBuilder();

    private GXHTTPStreamRequest(String address) {
        this.builder.connection = new GXConnection(address);
    }

    public static GXHTTPStreamRequest newRequest(String address) {
        return new GXHTTPStreamRequest(address);
    }

    @Override
    public GXInboundResponse put(InputStream body) throws Exception {
        if (Objects.nonNull(body)) {
            this.builder.connection.addBodyAsStream(body);
        }
        logger.trace("Sending a PUT request...");
        return new GXInboundResponse(this.builder.connection.send(GXConnection.HTTPMETHOD.PUT));
    }

    @Override
    public GXInboundResponse post(InputStream body) throws Exception {
        logger.trace("Sending a POST request...");
        if (Objects.nonNull(body)) {
            this.builder.connection.addBodyAsStream(body);
        }
        return new GXInboundResponse(this.builder.connection.send(GXConnection.HTTPMETHOD.POST));
    }

    @Override
    public GXInboundResponse put() throws Exception {
        return new GXInboundResponse(this.builder.put());
    }

    @Override
    public GXInboundResponse delete() throws Exception {
        return new GXInboundResponse(this.builder.delete());
    }

    @Override
    public GXInboundResponse head() throws Exception {
        return new GXInboundResponse(this.builder.head());
    }

    @Override
    public GXInboundResponse get() throws Exception {
        return new GXInboundResponse(this.builder.get());
    }

    @Override
    public GXInboundResponse post() throws Exception {
        return new GXInboundResponse(this.builder.post());
    }

    @Override
    public GXInboundResponse trace() throws Exception {
        return new GXInboundResponse(this.builder.trace());
    }

    @Override
    public GXInboundResponse patch() throws Exception {
        return new GXInboundResponse(this.builder.patch());
    }

    @Override
    public GXInboundResponse options() throws Exception {
        return new GXInboundResponse(this.builder.options());
    }

    @Override
    public GXInboundResponse connect() throws Exception {
        return new GXInboundResponse(this.builder.connect());
    }

    public GXHTTPStreamRequest from(String agent) {
        this.builder.from(agent);
        return this;
    }

    public void clear() {
        this.builder.clear();
    }

    public GXHTTPStreamRequest path(String path) throws UnsupportedEncodingException {
        this.builder.path(path);
        return this;
    }

    public GXHTTPStreamRequest header(String name, String value) {
        this.builder.header(name, value);
        return this;
    }

    public GXHTTPStreamRequest queryParams(Map<String, String> queryParams) throws UnsupportedEncodingException {
        this.builder.queryParams(queryParams);
        return this;
    }
}

