/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.calls.jaxrs;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.gcube.common.calls.Interceptors;
import org.gcube.common.calls.Request;
import org.gcube.common.calls.jaxrs.GcubeService;
import org.gcube.common.security.providers.SecretManagerProvider;

public class JaxRSRequestFilter
implements ClientRequestFilter {
    private GcubeService service;

    public JaxRSRequestFilter(GcubeService service) {
        this.service = service;
    }

    @Override
    public void filter(ClientRequestContext rc) throws IOException {
        if (SecretManagerProvider.get() != null) {
            Request requestContext = Interceptors.executeRequestChain(this.service.call());
            for (Map.Entry<String, String> entry : requestContext.getHeaders()) {
                rc.getHeaders().put(entry.getKey(), Collections.singletonList(entry.getValue()));
            }
        }
    }
}

