/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.util.transform.EfficientStreamingTransformer;
import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlDataContentHandler
implements DataContentHandler {
    @Override
    public ActivationDataFlavor[] getTransferDataFlavors() {
        ActivationDataFlavor[] flavors = new ActivationDataFlavor[]{new ActivationDataFlavor(StreamSource.class, "text/xml", "XML"), new ActivationDataFlavor(StreamSource.class, "application/xml", "XML")};
        return flavors;
    }

    @Override
    public Object getTransferData(ActivationDataFlavor flavor, DataSource dataSource) throws IOException {
        if ((flavor.getMimeType().startsWith("text/xml") || flavor.getMimeType().startsWith("application/xml")) && StreamSource.class.getName().equals(flavor.getRepresentationClass().getName())) {
            return new StreamSource(dataSource.getInputStream());
        }
        return null;
    }

    @Override
    public Object getContent(DataSource dataSource) throws IOException {
        return new StreamSource(dataSource.getInputStream());
    }

    @Override
    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (!mimeType.startsWith("text/xml") && !mimeType.startsWith("application/xml")) {
            throw new IOException("Invalid content type \"" + mimeType + "\" for XmlDCH");
        }
        try {
            Transformer transformer = EfficientStreamingTransformer.newTransformer();
            StreamResult result = new StreamResult(os);
            if (obj instanceof DataSource) {
                transformer.transform((Source)this.getContent((DataSource)obj), result);
            } else {
                Source src = null;
                src = obj instanceof String ? new StreamSource(new StringReader((String)obj)) : (Source)obj;
                transformer.transform(src, result);
            }
        }
        catch (Exception ex) {
            throw new IOException("Unable to run the JAXP transformer on a stream " + ex.getMessage());
        }
    }
}

