/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.gcube.io.jsonwebtoken.impl.lang.IdRegistry;
import org.gcube.io.jsonwebtoken.impl.security.AesGcmKeyAlgorithm;
import org.gcube.io.jsonwebtoken.impl.security.AesWrapKeyAlgorithm;
import org.gcube.io.jsonwebtoken.impl.security.DefaultRsaKeyAlgorithm;
import org.gcube.io.jsonwebtoken.impl.security.DirectKeyAlgorithm;
import org.gcube.io.jsonwebtoken.impl.security.EcdhKeyAlgorithm;
import org.gcube.io.jsonwebtoken.impl.security.Pbes2HsAkwAlgorithm;
import org.gcube.io.jsonwebtoken.lang.Collections;
import org.gcube.io.jsonwebtoken.security.KeyAlgorithm;

public final class StandardKeyAlgorithms
extends IdRegistry<KeyAlgorithm<?, ?>> {
    public static final String NAME = "JWE Key Management Algorithm";
    private static final String RSA1_5_ID = "RSA1_5";
    private static final String RSA1_5_TRANSFORMATION = "RSA/ECB/PKCS1Padding";
    private static final String RSA_OAEP_ID = "RSA-OAEP";
    private static final String RSA_OAEP_TRANSFORMATION = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";
    private static final String RSA_OAEP_256_ID = "RSA-OAEP-256";
    private static final String RSA_OAEP_256_TRANSFORMATION = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
    private static final AlgorithmParameterSpec RSA_OAEP_256_SPEC = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);

    public StandardKeyAlgorithms() {
        super(NAME, Collections.of(new DirectKeyAlgorithm(), new AesWrapKeyAlgorithm(128), new AesWrapKeyAlgorithm(192), new AesWrapKeyAlgorithm(256), new AesGcmKeyAlgorithm(128), new AesGcmKeyAlgorithm(192), new AesGcmKeyAlgorithm(256), new Pbes2HsAkwAlgorithm(128), new Pbes2HsAkwAlgorithm(192), new Pbes2HsAkwAlgorithm(256), new EcdhKeyAlgorithm(), new EcdhKeyAlgorithm(new AesWrapKeyAlgorithm(128)), new EcdhKeyAlgorithm(new AesWrapKeyAlgorithm(192)), new EcdhKeyAlgorithm(new AesWrapKeyAlgorithm(256)), new DefaultRsaKeyAlgorithm(RSA1_5_ID, RSA1_5_TRANSFORMATION), new DefaultRsaKeyAlgorithm(RSA_OAEP_ID, RSA_OAEP_TRANSFORMATION), new DefaultRsaKeyAlgorithm(RSA_OAEP_256_ID, RSA_OAEP_256_TRANSFORMATION, RSA_OAEP_256_SPEC)));
    }
}

