/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import javax.crypto.SecretKey;
import org.gcube.io.jsonwebtoken.impl.security.DefaultKeyResult;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.security.DecryptionKeyRequest;
import org.gcube.io.jsonwebtoken.security.KeyAlgorithm;
import org.gcube.io.jsonwebtoken.security.KeyRequest;
import org.gcube.io.jsonwebtoken.security.KeyResult;
import org.gcube.io.jsonwebtoken.security.SecurityException;

public class DirectKeyAlgorithm
implements KeyAlgorithm<SecretKey, SecretKey> {
    static final String ID = "dir";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public KeyResult getEncryptionKey(KeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, "request cannot be null.");
        SecretKey key = (SecretKey)Assert.notNull(request.getPayload(), "Encryption key cannot be null.");
        return new DefaultKeyResult(key);
    }

    @Override
    public SecretKey getDecryptionKey(DecryptionKeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, "request cannot be null.");
        return (SecretKey)Assert.notNull(request.getKey(), "Decryption key cannot be null.");
    }
}

