/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.lang;

import java.lang.reflect.Constructor;
import org.gcube.io.jsonwebtoken.impl.lang.CheckedFunction;
import org.gcube.io.jsonwebtoken.impl.lang.ConstantFunction;
import org.gcube.io.jsonwebtoken.impl.lang.DelegatingCheckedFunction;
import org.gcube.io.jsonwebtoken.impl.lang.Function;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Classes;
import org.gcube.io.jsonwebtoken.lang.Supplier;

public class PropagatingExceptionFunction<T, R, E extends RuntimeException>
implements Function<T, R> {
    private final CheckedFunction<T, R> function;
    private final Function<T, String> msgFunction;
    private final Class<E> clazz;

    public PropagatingExceptionFunction(Function<T, R> f, Class<E> exceptionClass, String msg) {
        this(new DelegatingCheckedFunction<T, R>(f), exceptionClass, new ConstantFunction(msg));
    }

    public PropagatingExceptionFunction(CheckedFunction<T, R> f, Class<E> exceptionClass, String msg) {
        this(f, exceptionClass, new ConstantFunction(msg));
    }

    public PropagatingExceptionFunction(CheckedFunction<T, R> fn, Class<E> exceptionClass, final Supplier<String> msgSupplier) {
        this(fn, exceptionClass, new Function<T, String>(){

            @Override
            public String apply(T t) {
                return (String)msgSupplier.get();
            }
        });
    }

    public PropagatingExceptionFunction(CheckedFunction<T, R> f, Class<E> exceptionClass, Function<T, String> msgFunction) {
        this.clazz = Assert.notNull(exceptionClass, "Exception class cannot be null.");
        this.msgFunction = Assert.notNull(msgFunction, "msgFunction cannot be null.");
        this.function = Assert.notNull(f, "Function cannot be null");
    }

    @Override
    public R apply(T t) {
        try {
            return this.function.apply(t);
        }
        catch (Exception e) {
            if (this.clazz.isAssignableFrom(e.getClass())) {
                throw (RuntimeException)this.clazz.cast(e);
            }
            String msg = this.msgFunction.apply(t);
            if (!msg.endsWith(".")) {
                msg = msg + ".";
            }
            msg = msg + " Cause: " + e.getMessage();
            Class<E> clazzz = this.clazz;
            Constructor<E> ctor = Classes.getConstructor(clazzz, String.class, Throwable.class);
            throw (RuntimeException)Classes.instantiate(ctor, msg, e);
        }
    }
}

